---
title: Historical (2018) · Cloudflare Web Application Firewall (WAF) docs
description: Changes to WAF managed rulesets done in 2018, before the public
  changelog was available.
lastUpdated: 2025-02-18T19:39:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/change-log/historical-2018/
  md: https://developers.cloudflare.com/waf/change-log/historical-2018/index.md
---

| Ruleset | Rule ID | Description | Change Date | Old Action | New Action |
| - | - | - | - | - | - |
| Cloudflare Specials | 100016\_BETA | Improved sensitive directories access | 2018-12-11 | Log | Block |
| Cloudflare Specials | 100035U\_BETA | Improved Baidu bot detection | 2018-12-06 | Log | Block |
| Cloudflare Specials | 100026\_BETA | Improved PHP injection detection | 2018-12-06 | Log | Block |
| Cloudflare Specials | 100118 | Improved SQLi detection | 2018-11-19 | Log | Block |
| Cloudflare Specials | 100116 | For[CVE-2018-9206](https://nvd.nist.gov/vuln/detail/CVE-2018-9206), vulnerable jQuery File Uploader | 2018-11-19 | Log | Block |
| Cloudflare Specials | 100117 | For[CVE-2018-9206](https://nvd.nist.gov/vuln/detail/CVE-2018-9206), vulnerable jQuery File Uploader | 2018-11-19 | Log | Block |
| Cloudflare Specials | 100008\_BETA | Improved SQLi detection | 2018-11-12 | Log | Block |
| Cloudflare Specials | 100114 | XSS probing detection | 2018-11-12 | Log | Block |
| Cloudflare Specials | 100097 | libinjection based SQLi detection rule | 2018-10-29 | N/A | Disable |
| Cloudflare Specials | 100097F | libinjection based SQLi detection rule | 2018-10-29 | Log | Block |
| Cloudflare Specials | 100070 | Block requests with invalid x-forwarded-for headers | 2018-10-22 | Log | Block |
| Cloudflare Specials | 100107 | Improved XSS Probing detection | 2018-10-22 | Log | Block |
| Cloudflare Specials | 100111 | Detect large numbers of GET parameters in requests | 2018-10-22 | Log | Block |
| Cloudflare Specials | 100109 | Detect large numbers of GET parameters in requests | 2018-10-22 | Log | Block |
| Cloudflare Specials | 100109B | Detect large numbers of GET parameters in requests | 2018-10-22 | Log | Log |
| Cloudflare Specials | 100110 | Detect large numbers of GET parameters in requests | 2018-10-22 | Disable | Disable |
| Cloudflare Specials | 100112 | Block requests with duplicated headers | 2018-10-15 | N/A | Disable |
| Cloudflare WordPress | WP0020 | WP allowlist | 2018-10-08 | Allow | Allow |
| Cloudflare WordPress | WP0004 | WP allowlist | 2018-10-08 | Allow | Allow |
| Cloudflare Specials | 100088B\_BETA | Improved XXE detection | 2018-10-08 | Log | Block |
| Cloudflare Specials | 100030 | Improved XSS Probing detection | 2018-10-08 | Challenge | Block |
| Cloudflare Specials | 100021B | Improved XSS Probing detection | 2018-10-08 | Block | Block |
| Cloudflare Specials | 100030\_BETA | Improved XSS Probing detection | 2018-10-08 | Log | Block |
| Cloudflare Specials | 100008CW\_BETA | Improved SQLi sleep probing | 2018-10-01 | Log | Block |
| Cloudflare Specials | 100106 | Improved SQLi detection | 2018-10-01 | Log | Block |
| Cloudflare Specials | 100009J\_BETA | Improved SQLi detection | 2018-10-01 | Log | Block |
| Cloudflare Specials | 100009CB | Improved SQLi detection | 2018-09-24 | Log | Block |
| Cloudflare Specials | 100102 | Rules to stop file read and deletion vulnerabilities in Ghostscript | 2018-09-24 | Log | Block |
| Cloudflare Specials | 100103 | Rules to stop file read and deletion vulnerabilities in Ghostscript | 2018-09-24 | Log | Block |
| Cloudflare OWASP | 950907 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare OWASP | 950008 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare OWASP | 950010 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare OWASP | 950011 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare OWASP | 960008 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare OWASP | 960015 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare OWASP | 960009 | Additional OWASP rules can be disabled in UI | 2018-09-24 | N/A | N/A |
| Cloudflare Specials | 100009C\_BETA | Improved SQLi detection | 2018-09-17 | Log | Deleted |
| Cloudflare Specials | 100101 | Vulnerability in Ghostscript | Emergency, 2018-09-12 | N/A | Block |
| Cloudflare Specials | 100021CE | Improved XSS Detection | 2018-09-10 | Block | Block |
| Cloudflare Specials | 100088B | Improved XXE Detection | 2018-09-10 | Log | Block |
| Cloudflare Specials | 100091B | Improved XSS Detection | 2018-09-10 | N/A | Block |
| Cloudflare Specials | 100038 | Blocks requests to `/server_status`, which gives away information on how a server works. | 2018-09-06 | Log | Block |
| Cloudflare Plone | PLONE0002 | Update rule regex | 2018-08-28 | Block | Block |
| Cloudflare Specials | 100021CE\_BETA | Improved XSS Detection | 2018-08-28 | Log | Block |
| Cloudflare Specials | 100030SVG\_BETA | Improved XSS Detection | 2018-08-28 | Log | Block |
| Cloudflare Specials | 100090 | Improved XSS Detection | 2018-08-28 | Log | Block |
| Cloudflare Specials | 100091 | Improved XSS Detection | 2018-08-28 | Log | Block |
| Cloudflare Specials | 100092 | Improved XSS Detection | 2018-08-28 | Log | Block |
| Cloudflare Specials | 100093 | Improved XSS Detection | 2018-08-28 | Log | Log |
| Cloudflare Specials | 100063 | Reduction in false positives | 2018-08-13 | Block | Block |
| Cloudflare Specials | 100035C | Improved detection of fake google bots | Emergency, 2018-08-13 | N/A | Block |
| Cloudflare Specials | 100095 | Rules to block cache poisoning attacks | Emergency, 2018-08-13 | N/A | Block |
| Cloudflare Specials | 100095B | Rules to block cache poisoning attacks | Emergency, 2018-08-13 | N/A | Block |
| Cloudflare WordPress | WP0003 | Disable login | 2018-08-13 | Allow | Allow |
| Cloudflare WordPress | WP0025B | Reduce the false positives WP0025B caused in the Gutenberg WordPress editor. | 2018-08-08 | Block | Block |
| Cloudflare WordPress | WP0025D | Reduce the false positives WP0025B caused in the Gutenberg WordPress editor. | 2018-08-08 | Block | Block |
| Cloudflare Drupal | D0006 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Block |
| Cloudflare Drupal | D0007 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Block |
| Cloudflare Drupal | D0008 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Disable |
| Cloudflare Drupal | D0009 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Disable |
| Cloudflare Drupal | D0010 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Disable |
| Cloudflare Drupal | D0011 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Disable |
| Cloudflare Drupal | D0012 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Disable |
| Cloudflare Drupal | D0013 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Block |
| Cloudflare Drupal | D0014 | Attempt to address SA-CORE-2018-005 by matching certain headers. | Emergency, 2018-08-03 | N/A | Block |
| Cloudflare Specials | 100089 | Improved SQLi detection | 2018-07-30 | Log | Block |
