---
title: How do I enable HTTP2 Server Push in WordPress · Cloudflare Support docs
description: HTTP/2 Server Push allows a website to push content to a browser,
  without having to wait for the HTML of one page to render first. In
  conjunction with the concurrency support built into HTTP/2, Server Push is
  able to dramatically reduce the amount of requests needed to load your
  website.
lastUpdated: 2025-09-26T09:58:28.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/third-party-software/content-management-system-cms/how-do-i-enable-http2-server-push-in-wordpress/
  md: https://developers.cloudflare.com/support/third-party-software/content-management-system-cms/how-do-i-enable-http2-server-push-in-wordpress/index.md
---

HTTP/2 Server Push allows a website to push content to a browser, without having to wait for the HTML of one page to render first. In conjunction with the concurrency support built into HTTP/2, Server Push is able to dramatically reduce the amount of requests needed to load your website.

![Old URL: https://support.cloudflare.com/hc/en-us/article\_attachments/115005733367/http2-server-push-2.png
Article IDs: 115002816808 | How do I enable HTTP/2 Server Push in WordPress
](https://developers.cloudflare.com/_astro/hc-import-http2_server_push_2.CwfrU1Mt_Z2qzhSt.webp)

Cloudflare supports HTTP/2 Server Push and it can be enabled for stylesheets and scripts using Cloudflare’s WordPress plugin. In order to utilise this feature, you must first ensure you have the Cloudflare WordPress plugin [installed and set up on your site](https://developers.cloudflare.com/automatic-platform-optimization/).

Once the plugin is installed, you can enable HTTP/2 Server Push by adding the following line to your `wp-config.php` file:

```php
define('CLOUDFLARE_HTTP2_SERVER_PUSH_ACTIVE', true);
```

You should insert this line above where it says *"/\* That's all, stop editing! Happy blogging. \*/*", like follows:|

![Old URL: https://support.cloudflare.com/hc/en-us/article\_attachments/115005733547/Screen\_Shot\_2017-02-09\_at\_16.09.31.png
Article IDs: 115002816808 | How do I enable HTTP/2 Server Push in WordPress
](https://developers.cloudflare.com/_astro/hc-import-screen_shot_2017_02_09_at_16_09_31.CgPyEpOq_GAG8w.webp)

You should then start to see requests coming in which are initiated through Server Push, for example, in the Network tab of Chrome Development Tools you should see some assets have "Push" as the initiator:

![Old URL: https://support.cloudflare.com/hc/en-us/article\_attachments/115005787688/Screen-Shot-2016-04-26-at-15-08-59.png
Article IDs: 115002816808 | How do I enable HTTP/2 Server Push in WordPress
](https://developers.cloudflare.com/_astro/hc-import-screen_shot_2016_04_26_at_15_08_59.CUaoZjsJ_Z2ndBce.webp)
