---
title: Public DNS setup - Keyless SSL · Cloudflare SSL/TLS docs
description: If you cannot use a Cloudflare Tunnel setup, you can also create a
  public DNS record for your key server.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/keyless-ssl/configuration/public-dns/
  md: https://developers.cloudflare.com/ssl/keyless-ssl/configuration/public-dns/index.md
---

If you cannot use a [Cloudflare Tunnel setup](https://developers.cloudflare.com/ssl/keyless-ssl/configuration/cloudflare-tunnel/), you can also create a public DNS record for your key server.

This setup option is not ideal as the DNS record cannot be [proxied](https://developers.cloudflare.com/dns/proxy-status/) and - as a result - will expose the origin IP address of your key server.

***

## Before you begin

### Supported platforms

Keyless has been tested on `amd64` and `arm` architectures. The key server binary will likely run on all architectures that Go supports. Code support may exist for other CPUs too, but these other architectures have not been tested.

In addition to running on bare metal, the key server should run without issue in a virtualized or containerized environment. Care will need to be taken to configure ingress access to the appropriate TCP port and file system access to private keys (if using filesystem storage).

### Supported operating systems

You will need to have a supported operating system (OS) to run Keyless. Supported operating systems include:

* Ubuntu 14.04 LTS, 16.04 LTS, 18.04 LTS, 20.04 LTS, 22.04 LTS, 22.10
* Debian 8, 9, 10, 11, 12
* RHEL and CentOS 6, 7, 8, 9
* Amazon Linux 1, 2

We strongly recommend that you use an operating system still supported by the vendor (still receiving security updates) as your key server will have access to your private keys.

***

## 1. Create public DNS record

1. Open a Terminal and run `openssl rand -hex 24` to generate a long, random hostname such as `11aa40b4a5db06d4889e48e2f738950ddfa50b7349d09b5f.example.com`.
2. Add this record via your DNS provider’s interface as an **A** or **AAAA** record pointing to the IP address of your Keyless SSL server.
3. Use this hostname as the server hostname during initialization of your Keyless SSL server.

Warning

As a security measure, you should hide the hostname of your key server.

***

## 2. Upload Keyless SSL Certificates

Before your key servers can be configured, you must next upload the corresponding SSL certificates to Cloudflare’s edge. During TLS termination, Cloudflare will present these certificates to connecting browsers and then (for non-resumed sessions) communicate with the specified key server to complete the handshake.

Upload certificates to Cloudflare with only SANs that you wish to use with Cloudflare Keyless SSL. All Keyless SSL hostnames must be [proxied](https://developers.cloudflare.com/dns/proxy-status/).

You will have to upload each certificate used with Keyless SSL.

* Dashboard

  To create a Keyless certificate in the dashboard:

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account and zone.
  2. Go to **SSL/TLS** > **Edge Certificates**.
  3. Select **Upload Keyless SSL Certificate**.
  4. Fill in the upload modal with the certificate and other details and select **Add**.

  | Label | Description | Example Values |
  | - | - | - |
  | Key server label | Any unique identifier for your key server. | “test-keyless”, “production-keyless-1” |
  | Key server hostname | The hostname of your key server that holds the key for this certificate (such as the random hostname generated earlier). | 11aa40b4a5db06d4889e48e2f738950ddfa50b7349d09b5f.example.com |
  | Key server port | Set to 2407 unless you have changed this on the key server. | 2407 |
  | SSL Certificate | The valid X509v3 SSL certificate (in PEM form) for which you hold the private key. | (PEM bytes) |
  | Bundle method | This should almost always be **Compatible**. Refer to [Uploading Custom Certificates](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/) for more details. | Compatible |

* API

  To create a Keyless certificate with the API, send a [`POST`](https://developers.cloudflare.com/api/resources/keyless_certificates/methods/create/) request.

***

## 3. Set up and activate key server

Finally, you need to install the key server on your infrastructure, populate it with the SSL keys of the certificates you wish to use to terminate TLS at Cloudflare’s edge, and activate the key server so it can be mutually authenticated.

Note

If you plan to run Keyless SSL in a [high availability setup](https://developers.cloudflare.com/ssl/keyless-ssl/reference/high-availability/), you may need to set up additional infrastructure (load balancing and health checks).

### Install

These steps are also at the [Cloudflare package repository](https://pkg.cloudflare.com/).

#### Debian/Ubuntu packages

```sh
sudo mkdir -p --mode=0755 /usr/share/keyrings
curl -fsSL https://pkg.cloudflare.com/cloudflare-main.gpg | sudo tee /usr/share/keyrings/cloudflare-main.gpg >/dev/null


# Add this repo to your apt repositories
echo 'deb [signed-by=/usr/share/keyrings/cloudflare-main.gpg] https://pkg.cloudflare.com/gokeyless buster main' | sudo tee /etc/apt/sources.list.d/cloudflare.list


# install gokeyless
sudo apt-get update && sudo apt-get install gokeyless
```

#### RHEL/CentOS packages

Use either of the following examples to install the `gokeyless` package for RHEL or CentOS.

**Option 1**

```sh
sudo yum makecache
sudo yum-config-manager --add-repo https://pkg.cloudflare.com/gokeyless.repo && sudo yum-config-manager --setopt=gokeyless-stable.gpgkey=https://pkg.cloudflare.com/cloudflare-ascii-pubkey.gpg --save
sudo yum install gokeyless
```

**Option 2**

```sh
sudo dnf install dnf-plugins-core && dnf clean all
sudo dnf config-manager --add-repo https://pkg.cloudflare.com/gokeyless.repo
sudo dnf install gokeyless
```

Note

Amazon Linux customers may need to update their final installation command to be something similar to `sudo yum install rsyslog shadow-utils && sudo yum install gokeyless`.

### Configure

Add your Cloudflare account details to the configuration file located at `/etc/keyless/gokeyless.yaml`:

1. Set the hostname of the key server, for example, `11aa40b4a5db06d4889e48e2f.example.com`. This is also the value you entered when you uploaded your keyless certificate and is the hostname of your key server that holds the key for this certificate.
2. Set the Zone ID (found on **Overview** tab of the Cloudflare dashboard).
3. [Set the Origin CA API key](https://developers.cloudflare.com/fundamentals/api/get-started/ca-keys).

### Populate keys

Install your private keys in `/etc/keyless/keys/` and set the user and group to keyless with 400 permissions. Keys must be in PEM or DER format and have an extension of `.key`:

```sh
ls -l /etc/keyless/keys
```

```sh
-r-------- 1 keyless keyless 1675 Nov 18 16:44 example.com.key
```

When running multiple key servers, make sure all required keys are distributed to each key server. Customers typically will either use a configuration management tool such as Salt or Puppet to distribute keys or mount `/etc/keyless/keys` to a network location accessible only by your key servers. Keys are read on boot into memory, so a network path must be accessible during the gokeyless process start/restart.

### Activate

To activate, restart your keyless instance:

* systemd: `sudo service gokeyless restart`
* upstart/sysvinit: `sudo /etc/init.d/gokeyless restart`

If this command fails, try troubleshooting by [checking the logs](https://developers.cloudflare.com/ssl/keyless-ssl/troubleshooting/).

### Allow incoming connections from Cloudflare

During TLS handshakes, Cloudflare's keyless client will initiate connections to the key server hostname or IP address you specify during certificate upload. By default, the keyless client will use a destination TCP port of 2407, but this can be changed during certificate upload or by editing the certificate details after upload.

Create WAF custom rules that allow your key server to accept connections from only Cloudflare. You can get Cloudflare's IPv4 and IPv6 addresses via the [IP details API endpoint](https://developers.cloudflare.com/api/resources/ips/methods/list/).
