---
title: Configuration · Cloudflare Sandbox SDK docs
description: Configure your Sandbox SDK deployment with Wrangler, customize
  container images, and manage environment variables.
lastUpdated: 2025-10-15T15:03:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/configuration/
  md: https://developers.cloudflare.com/sandbox/configuration/index.md
---

Configure your Sandbox SDK deployment with Wrangler, customize container images, and manage environment variables.

[Wrangler configuration](https://developers.cloudflare.com/sandbox/configuration/wrangler/)

Configure Durable Objects bindings, container images, and Worker settings in wrangler.jsonc.

[Dockerfile reference](https://developers.cloudflare.com/sandbox/configuration/dockerfile/)

Customize the sandbox container image with your own packages, tools, and configurations.

[Environment variables](https://developers.cloudflare.com/sandbox/configuration/environment-variables/)

Pass configuration and secrets to your sandboxes using environment variables.

## Quick reference

### Essential wrangler.jsonc settings

```jsonc
{
  "name": "my-worker",
  "main": "src/index.ts",
  "compatibility_date": "2024-09-02",
  "compatibility_flags": ["nodejs_compat"],
  "durable_objects": {
    "bindings": [
      {
        "name": "Sandbox",
        "class_name": "Sandbox",
        "script_name": "@cloudflare/sandbox"
      }
    ]
  },
  "containers": [
    {
      "binding": "CONTAINER",
      "image": "ghcr.io/cloudflare/sandbox-runtime:latest"
    }
  ]
}
```

### Common Dockerfile customizations

```dockerfile
FROM ghcr.io/cloudflare/sandbox-runtime:latest


# Install additional Python packages
RUN pip install scikit-learn tensorflow pandas


# Install Node.js packages globally
RUN npm install -g typescript ts-node


# Install system packages
RUN apt-get update && apt-get install -y postgresql-client


# Add custom scripts
COPY ./scripts /usr/local/bin/
```

### Environment variables

```typescript
// Pass to sandbox at creation
const sandbox = getSandbox(env.Sandbox, 'my-sandbox');


// Configure environment for commands
await sandbox.exec('node app.js', {
  env: {
    NODE_ENV: 'production',
    API_KEY: env.API_KEY,
    DATABASE_URL: env.DATABASE_URL
  }
});
```

## Related resources

* [Get Started guide](https://developers.cloudflare.com/sandbox/get-started/) - Initial setup walkthrough
* [Wrangler documentation](https://developers.cloudflare.com/workers/wrangler/) - Complete Wrangler reference
* [Docker documentation](https://docs.docker.com/engine/reference/builder/) - Dockerfile syntax
* [Security model](https://developers.cloudflare.com/sandbox/concepts/security/) - Understanding environment isolation
