---
title: API Reference · Cloudflare Sandbox SDK docs
description: The Sandbox SDK provides a comprehensive API for executing code,
  managing files, running processes, and exposing services in isolated
  sandboxes. All operations are performed through the Sandbox instance you
  obtain via getSandbox().
lastUpdated: 2025-10-15T15:03:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/api/
  md: https://developers.cloudflare.com/sandbox/api/index.md
---

The Sandbox SDK provides a comprehensive API for executing code, managing files, running processes, and exposing services in isolated sandboxes. All operations are performed through the `Sandbox` instance you obtain via `getSandbox()`.

## Getting a sandbox instance

```typescript
import { getSandbox } from '@cloudflare/sandbox';


const sandbox = getSandbox(env.Sandbox, 'user-123');
```

The sandbox ID should be unique per user or session. The same ID will always return the same sandbox instance with persistent state.

## API organization

The Sandbox SDK is organized into focused APIs:

[Commands](https://developers.cloudflare.com/sandbox/api/commands/)

Execute commands and stream output. Includes `exec()`, `execStream()`, and background process management.

[Files](https://developers.cloudflare.com/sandbox/api/files/)

Read, write, and manage files in the sandbox filesystem. Includes directory operations and file metadata.

[Code Interpreter](https://developers.cloudflare.com/sandbox/api/interpreter/)

Execute Python and JavaScript code with rich outputs including charts, tables, and formatted data.

[Ports](https://developers.cloudflare.com/sandbox/api/ports/)

Expose services running in the sandbox via preview URLs. Access web servers and APIs from the internet.

[Sessions](https://developers.cloudflare.com/sandbox/api/sessions/)

Advanced: Create isolated execution contexts with persistent shell state. Configure environment variables and manage container lifecycle.
