---
title: http.response.headers · Cloudflare Ruleset Engine docs
description: The HTTP response headers represented as a Map (or associative array).
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.headers/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.headers/index.md
---

# http.response.headers

`http.response.headers` Map\<Array\<String>>

The HTTP response headers represented as a Map (or associative array).

When there are repeating headers, the array includes them in the order they appear in the response. The keys convert to lowercase.

* **Decoding**: No decoding performed
* **Whitespace**: Preserved
* **Non-ASCII**: Preserved

Example value:

```txt
{"server": ["nginx"]}
```

Example usage:

```txt
any(http.response.headers["server"][*] == "nginx")
```

Categories:

* Response
* Headers
