---
title: Redirect from WWW to root · Cloudflare Rules docs
description: Create a redirect rule to forward HTTPS requests from the WWW
  subdomain to the root (also known as the “apex” or “naked” domain).
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-www-to-root/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-www-to-root/index.md
---

This example creates a redirect rule that forwards HTTPS requests from the WWW subdomain (`www.example.com`) to the root domain (`example.com`), while retaining the original path and query string.

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `https://www.*`

**Then**

* **Target URL**: `https://${1}`
* **Status code**: *301*
* **Preserve query string**: Enabled

This rule ensures that only HTTPS requests from `www.` subdomains are redirected to the root domain, leaving other requests (such as HTTP or non-WWW) unchanged.

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `https://www.example.com/products/` | `https://example.com/products/` | `301` |
| `https://www.store.example.com/products/` | `https://store.example.com/products/` | `301` |
| `https://store.example.com/products/` | (unchanged) | n/a |
| `https://www.example.com/admin/?logged_out=true` | `https://example.com/admin/?logged_out=true` | `301` |
| `http://www.example.com/?all_items=true` | (unchanged) | n/a |
| `http://example.com/admin/` | (unchanged) | n/a |
