---
title: Error page types · Cloudflare Rules docs
description: "The following error page types will only be shown in the
  Cloudflare dashboard if you have customized their error pages in the past:"
lastUpdated: 2025-06-04T08:56:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/custom-errors/reference/error-page-types/
  md: https://developers.cloudflare.com/rules/custom-errors/reference/error-page-types/index.md
---

| Page type | Description | API identifier |
| - | - | - |
| WAF block | The page displayed when visitors are blocked by a [Web Application Firewall](https://developers.cloudflare.com/waf/) rule. This page returns a `403` status code. | `waf_block` |
| IP/Country block | The page displayed when a request originates from a [blocked IP address or country](https://developers.cloudflare.com/waf/tools/ip-access-rules/). This page returns a `403` status code. | `ip_block` |
| IP/Country challenge | Presents a challenge to visitors from specified IP addresses or countries. This page returns a `403` status code. For more information, refer to [IP Access rules](https://developers.cloudflare.com/waf/tools/ip-access-rules/). | `country_challenge` |
| 500 class errors | 500 class error pages are displayed when a web server is unable to process a request. For more information, refer to [Cloudflare 5XX errors](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/). | `500_errors` |
| 1000 class errors | 1000 class error pages are displayed when a domain’s configuration, security settings, or origin setup prevents Cloudflare from completing a request. For more information, refer to [Cloudflare 1XXX errors](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/). | `1000_errors` |
| Managed challenge / I'm Under Attack Mode | Presents different types of challenges to a visitor depending on the nature of their request and your security settings. This page returns a `403` status code. For more information, refer to [Under Attack mode](https://developers.cloudflare.com/fundamentals/reference/under-attack-mode/). | `managed_challenge` |
| Rate limiting block | Displayed to visitors when they have been blocked by a [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/). This page returns a `429` status code. | `ratelimit_block` |

The following error page types will only be shown in the Cloudflare dashboard if you have customized their error pages in the past:

| Page type | API identifier |
| - | - |
| Interactive Challenge | `basic_challenge` |
| JavaScript Challenge | `under_attack` |

These types of challenges are being discouraged in favor of managed challenges. Refer to [Challenge pages](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/) for more information.
