---
title: Learn how to manage a .US domain with Cloudflare. · Cloudflare Registrar docs
description: "If you want to register a .us domain, you must have a genuine
  connection to the United States as described in the usTLD Nexus Policy. When
  registering a domain name, registrants must identify the category under which
  they qualify for the usTLD Nexus Requirement:"
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/registrar/top-level-domains/us-domains/
  md: https://developers.cloudflare.com/registrar/top-level-domains/us-domains/index.md
---

## Registration requirements for .US domains

If you want to register a `.us` domain, you must have a genuine connection to the United States as described in the [usTLD Nexus Policy](https://www.about.us/policies). When registering a domain name, registrants must identify the category under which they qualify for the usTLD Nexus Requirement:

Nexus Category 1

**C11**: A natural person who is a United States Citizen; or

**C12**: A natural person who is a permanent resident of the United States of America, or any of its possessions or territories.

Nexus Category 2

**C21**: A U.S.-based organization or company formed within one of the fifty (50) U.S. states, the District of Columbia, or any of the United States possessions or territories, or organized or otherwise constituted under the laws of a state of the United States of America, the District of Columbia or any of its possessions or territories or a U.S. federal, state, or local government entity or a political subdivision thereof.

Nexus Category 3

**C31**: A foreign entity or organization that has a bona fide presence in the United States of America or any of its possessions or territories who regularly engages in lawful activities, sales of goods or services or other business, commercial or non-commercial, including not-for-profit relations in the United States; or

**C32**: A foreign entity that has an office or other facility in the United States.

The nexus category information will be supplied to the .US registry. Failure to provide accurate information and/or to respond to requests for information may result in the suspension or cancellation of the domain registration.

### Application purpose

In addition to nexus information, registrants must also identify their intended use of the domain name. The possible options are:

* Personal use
* For-profit business
* Non-profit business or organization
* Government
* Education

### .US WHOIS requirements

The .US registry requires that domain contact data is displayed in the public WHOIS database. Redaction and/or use of WHOIS privacy services is prohibited. This is a registry policy that all registrars must comply with.

### .US domain transfers

Transferring a `.us` domain works in a similar way to other domains, but always requires approval via the Form of Authorization (FOA) email. You must select the approve link within five days for the transfer to proceed. If you do not respond, the transfer request will be cancelled.

Refer to [Transfer your domain to Cloudflare](https://developers.cloudflare.com/registrar/get-started/transfer-domain-to-cloudflare/) for more information.
