---
title: Proxy traffic through Gateway · Cloudflare Learning Paths
description: With Cloudflare Gateway, you can log and filter DNS, network, and
  HTTP traffic from devices running the WARP client. This includes traffic to
  the public Internet and traffic directed to your private network. DNS
  filtering is enabled by default since the WARP client sends DNS queries to
  Cloudflare's public DNS resolver, 1.1.1.1. To enable network and HTTP
  filtering, you will need to allow Cloudflare Gateway to proxy that traffic.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/enable-proxy/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/enable-proxy/index.md
---

With Cloudflare Gateway, you can log and filter DNS, network, and HTTP traffic from devices running the WARP client. This includes traffic to the public Internet and traffic directed to your private network. DNS filtering is enabled by default since the WARP client sends DNS queries to Cloudflare's public DNS resolver, [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/). To enable network and HTTP filtering, you will need to allow Cloudflare Gateway to proxy that traffic.

## Enable the proxy

1. Go to **Settings** > **Network**.
2. Enable **Proxy** for TCP.
3. (Recommended) To proxy all port `443` traffic, including internal DNS queries, select **UDP**.
4. (Optional) To scan file uploads and downloads for malware, [enable anti-virus scanning](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/antivirus-scanning/).

Cloudflare will now proxy traffic from enrolled devices, except for the traffic excluded in your [split tunnel settings](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/#3-route-private-network-ips-through-warp). For more information on how Gateway forwards traffic, refer to [Gateway proxy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/proxy/).
