---
title: Recommended HTTP policies · Cloudflare Learning Paths
description: We recommend you add the following HTTP policies to build an
  Internet and SaaS app security strategy for your organization.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-http-policies/recommended-http-policies/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/build-http-policies/recommended-http-policies/index.md
---

We recommend you add the following HTTP policies to build an Internet and SaaS app security strategy for your organization.

## All-HTTP-Application-InspectBypass

Bypass HTTP inspection for applications that use embedded certificates. This will help avoid any certificate pinning errors that may arise from an initial rollout.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Application | in | *Do Not Inspect* | Do Not Inspect |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-Application-InspectBypass",
      "description": "Bypass HTTP inspection for applications that use embedded certificates",
      "precedence": 0,
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(app.type.ids[*] in {16})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "all_http_application_inspect_bypass" {
    account_id  = var.cloudflare_account_id
    name        = "All-HTTP-Application-InspectBypass"
    description = "Bypass HTTP inspection for applications that use embedded certificates"
    precedence  = 0
    enabled     = true
    action      = "block"
    filters     = ["http"]
    traffic     = "any(app.type.ids[*] in {16})"
  }
  ```

## Android-HTTP-Application-InspectionBypass

Bypass HTTPS inspection for Android applications (such as Google Drive) that use certificate pinning, which is incompatible with Gateway inspection.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Application | in | *Google Drive* | And | Do Not Inspect |
  | Passed Device Posture Checks | in | *OS Version Android (OS version)* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Android-HTTP-Application-InspectionBypass",
      "description": "Bypass HTTPS inspection for Android applications with certificate pinning",
      "precedence": 10,
      "enabled": true,
      "action": "off",
      "filters": [
          "http"
      ],
      "traffic": "any(app.ids[] in {554})",
      "device_posture": "any(device_posture.checks.passed[] in {\"<ANDROID_VERSION_POSTURE_CHECK_UUID >\"})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "android_http_application_inspection_bypass" {
    account_id  = var.cloudflare_account_id
    name        = "Android-HTTP-Application-InspectionBypass"
    description = "Bypass HTTPS inspection for Android applications with certificate pinning"
    precedence  = 10
    enabled     = true
    action      = "off"
    filters     = ["http"]
    traffic     = "any(app.ids[*] in {554})"
    device_posture = "any(device_posture.checks.passed[*] in {\"${"$"}{cloudflare_zero_trust_list.android_version_posture_check.id}\"})"
  }
  ```

## All-HTTP-Domain-Inspection-Bypass

Bypass HTTP inspection for a custom list of domains identified as incompatible with TLS inspection.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Domain | in list | *DomainInspectionBypass* | Or | Do Not Inspect |
  | Domain | in list | *Known Domains* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-Domain-Inspection-Bypass",
      "description": "Bypass HTTP inspection for a custom list of domains identified as incompatible with TLS inspection",
      "precedence": 20,
      "enabled": true,
      "action": "off",
      "filters": [
          "http"
      ],
      "traffic": "any(http.conn.domains[] in $<DOMAIN_INSPECTION_BYPASS_LIST_UUID>) or any(http.conn.domains[] in $<KNOWN_DOMAINS_LIST_UUID>)"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "android_http_application_inspection_bypass" {
    account_id  = var.cloudflare_account_id
    name        = "All-HTTP-Domain-Inspection-Bypass"
    description = "Bypass HTTP inspection for a custom list of domains identified as incompatible with TLS inspection"
    precedence  = 20
    enabled     = true
    action      = "off"
    filters     = ["http"]
    traffic     = "any(http.conn.domains[*] in ${"$"}{cloudflare_zero_trust_list.domain_inspection_bypass_list.id}) or any(http.conn.domains[*] in ${"$"}{cloudflare_zero_trust_list.known_domains_list.id})"
  }
  ```

## All-HTTP-SecurityRisks-Blocklist

Block [security categories](https://developers.cloudflare.com/cloudflare-one/policies/gateway/domain-categories/#security-categories), such as **Command and Control & Botnet** and **Malware**, based on Cloudflare's threat intelligence.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Security Categories | in | *All security risks* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-SecurityRisks-Blocklist",
      "description": "Block security categories based on Cloudflare'\''s threat intelligence",
      "precedence": 30,
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(http.request.uri.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "all_http_security_risks_blocklist" {
    account_id  = var.cloudflare_account_id
    name        = "All-HTTP-SecurityRisks-Blocklist"
    description = "Block security categories based on Cloudflare's threat intelligence"
    precedence  = 30
    enabled     = true
    action      = "block"
    filters     = ["http"]
    traffic     = "any(http.request.uri.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})"
  }
  ```

## All-HTTP-ContentCategories-Blocklist

Entries in the [security risk content subcategory](https://developers.cloudflare.com/cloudflare-one/policies/gateway/domain-categories/#security-risk-subcategories), such as **New Domains**, do not always pose a security threat. We recommend you first create an Allow policy to track policy matching and identify any false positives. You can add false positives to your **Trusted Domains** list used in **All-HTTP-Domain-Allowlist**.

After your test is complete, we recommend you change the action to Block to minimize risk to your organization.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Content Categories | in | *Questionable Content*, *Security Risks*, *Miscellaneous*, *Adult Themes*, *Gambling* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-ContentCategories-Blocklist",
      "description": "Block access to questionable content and potential security risks",
      "precedence": 40,
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(http.request.uri.content_category[*] in {17 85 87 102 157 135 138 180 162 32 169 177 128 15 115 119 124 141 161 2 67 125 133 99})",
      "identity": "",
      "device_posture": ""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "block_unauthorized_apps" {
    account_id     = var.cloudflare_account_id
    name           = "All-HTTP-ContentCategories-Blocklist"
    description    = "Block access to questionable content and potential security risks"
    precedence     = 40
    enabled        = true
    action         = "block"
    filters        = ["http"]
    traffic        = "any(http.request.uri.content_category[*] in {17 85 87 102 157 135 138 180 162 32 169 177 128 15 115 119 124 141 161 2 67 125 133 99})""
    identity       = ""
    device_posture = ""
  }
  ```

## All-HTTP-DomainHost-Blocklist

Block specific domains or hosts that are malicious or pose a threat to your organization. Like **All-HTTP-ResolvedIP-Blocklist**, this blocklist can be updated manually or via API automation.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Domain | in list | *Domain Blocklist* | Or | Block |
  | Host | in list | *Host Blocklist* | Or | |
  | Host | matches regex | `.*example\.com` | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-DomainHost-Blocklist",
      "description": "Block specific domains or hosts that are malicious or pose a threat to your organization",
      "precedence": 50,
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(http.request.domains[*] in $<DOMAIN_BLOCKLIST_UUID>) or http.request.host in $<HOST_BLOCKLIST_UUID> or http.request.host matches \".*example.com\""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "all_http_domainhost_blocklist" {
    account_id  = var.cloudflare_account_id
    name        = "All-HTTP-DomainHost-Blocklist"
    description = "Block specific domains or hosts that are malicious or pose a threat to your organization"
    precedence  = 50
    enabled     = true
    action      = "block"
    filters     = ["http"]
    traffic     = "any(http.request.domains[*] in ${"$"}{cloudflare_zero_trust_list.domain_blocklist.id}) or http.request.host in ${"$"}{cloudflare_zero_trust_list.host_blocklist.id} or http.request.host matches \".*example\\.com\""
  }
  ```

## All-HTTP-Application-Blocklist

Block unauthorized applications to limit your users' access to certain web-based tools and minimize the risk of [shadow IT](https://www.cloudflare.com/learning/access-management/what-is-shadow-it/). For example, the following policy blocks known AI tools:

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Application | in | *Artificial Intelligence* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-Application-Blocklist",
      "description": "Limit access to shadow IT by blocking web-based tools and applications",
      "precedence": 60,
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(app.type.ids[*] in {25})",
      "identity": "",
      "device_posture": ""
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "all_http_application_blocklist" {
    account_id     = var.cloudflare_account_id
    name           = "All-HTTP-Application-Blocklist"
    description    = "Limit access to shadow IT by blocking web-based tools and applications"
    precedence     = 60
    enabled        = true
    action         = "block"
    filters        = ["http"]
    traffic        = "any(app.type.ids[*] in {25})"
    identity       = ""
    device_posture = ""
  }
  ```

## PrivilegedUsers-HTTP-Any-Isolate

Isolate traffic for privileged users who regularly access critical systems or execute actions such as threat analysis and malware testing.

Security teams often need to perform threat analysis or malware testing that could trigger malware detection. Likewise, privileged users could be the target of attackers trying to gain access to critical systems.

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | User Group Names | in | *Privileged Users* | Isolate |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "PrivilegedUsers-HTTP-Any-Isolate",
      "description": "Isolate traffic for privileged users who regularly access critical or testing systems",
      "precedence": 70,
      "enabled": true,
      "action": "isolate",
      "filters": [
          "http"
      ],
      "identity": "any(identity.groups.name[*] in {\"Privileged Users\"})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "privileged_users_http_any_isolate" {
    account_id  = var.cloudflare_account_id
    name        = "PrivilegedUsers-HTTP-Any-Isolate"
    description = "Isolate traffic for privileged users who regularly access critical or testing systems"
    precedence  = 70
    enabled     = true
    action      = "isolate"
    filters     = ["http"]
    identity    = "any(identity.groups.name[*] in {\"Privileged Users\"})"
  }
  ```

## Quarantined-Users-HTTP-Restricted-Access

Restrict access for users included in an identity provider (IdP) user group for risky users. This policy ensures your security team can restrict traffic for users of whom malicious or suspicious activity was detected.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Destination IP | not in list | *Quarantined-Users-IPAllowlist* | And | Block |
  | User Group Names | in | *Quarantined Users* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Quarantined-Users-HTTP-Restricted-Access",
      "description": "Restrict access for users included in an identity provider (IdP) user group for risky users",
      "precedence": 80,
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "not(any(http.conn.dst_ip[] in $<QUARANTINED_USERS_IP_ALLOWLIST_UUID>))",
      "identity": "any(identity.groups.name[] in {\"Quarantined Users\"})"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "quarantined_users_http_restricted_access" {
    account_id  = var.cloudflare_account_id
    name        = "Quarantined-Users-HTTP-Restricted-Access"
    description = "Restrict access for users included in an identity provider (IdP) user group for risky users"
    precedence  = 80
    enabled     = true
    action      = "block"
    filters     = ["http"]
    traffic     = "not(any(http.conn.dst_ip[*] in ${"$"}{cloudflare_zero_trust_list.quarantined_users_ip_allowlist.id}))"
    identity    = "any(identity.groups.name[*] in {\"Quarantined Users\"})"
  }
  ```

## All-HTTP-Domain-Isolate

Isolate high risk domains or create a custom list of known risky domains to avoid data exfiltration or malware infection. Ideally, your incident response teams can update the blocklist with an [API automation](https://developers.cloudflare.com/security-center/intel-apis/) to provide real-time threat protection.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Content Categories | in | *New Domains*, *Newly Seen Domains* | Or | Isolate |
  | Domain | in list | *Domain Isolation* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-HTTP-Domain-Isolate",
      "description": "Isolate high risk domains or create a custom list of known risky domains to avoid data exfiltration or malware infection",
      "precedence": 90,
      "enabled": true,
      "action": "isolate",
      "filters": [
          "http"
      ],
      "traffic": "any(http.request.uri.content_category[] in {169 177}) or any(http.request.domains[] in $<DOMAIN_ISOLATE_LIST_UUID>)"
    }'
  ```

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "all_http_domain_isolate" {
    account_id  = var.cloudflare_account_id
    name        = "All-HTTP-Domain-Isolate"
    description = "Isolate high risk domains or create a custom list of known risky domains to avoid data exfiltration or malware infection"
    precedence  = 90
    enabled     = true
    action      = "isolate"
    filters     = ["http"]
    traffic     = "any(http.request.uri.content_category[*] in {169 177}) or any(http.request.domains[*] in ${"$"}{cloudflare_zero_trust_list.domain_isolate_list.id})"
  }
  ```
