---
title: Hostname preparation · Cloudflare Learning Paths
description: "Before setting up anything related to your load balancer, make
  sure you test that production hostnames meet the following criteria:"
lastUpdated: 2024-10-15T01:23:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/load-balancing/setup/hostname-preparation/
  md: https://developers.cloudflare.com/learning-paths/load-balancing/setup/hostname-preparation/index.md
---

Before setting up anything related to your load balancer, make sure you test that production hostnames meet the following criteria:

* Based on the [priority order](https://developers.cloudflare.com/load-balancing/load-balancers/dns-records/#priority-order) of DNS records, they will receive the intended amount of traffic.
* Each hostname is covered by an [SSL/TLS certificate](https://developers.cloudflare.com/load-balancing/load-balancers/dns-records/#ssltls-coverage).

After confirming each of these conditions are met, you can proceed with setting up your load balancer.

## Routing strategy

Depending on your preferences and infrastructure, you might route traffic to your load balancer in different ways:

* For most customers, it's simpler to create the load balancer on the hostname directly (`www.example.com`).
* However, you could also create the load balancer on another hostname (`lb.example.com`) and then route traffic using a `CNAME` record on `test.example.com` that points to `lb.example.com`.
