---
title: Technology partner integrations · Cloudflare Fundamentals docs
description: Cloudflare Technology Partners offer purpose-built integrations
  with our products, providing expanded functionality for our users. Learn how
  to configure these integrations with our tutorials and how-to guides.
lastUpdated: 2025-09-02T14:32:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/reference/partners/
  md: https://developers.cloudflare.com/fundamentals/reference/partners/index.md
---

[Cloudflare Technology Partners](https://www.cloudflare.com/partners/technology-partners/) offer purpose-built integrations with our products, providing expanded functionality for our users. Learn how to configure these integrations with our tutorials and how-to guides.

## Analytics integrations

Learn how to configure a variety of products with Cloudflare Analytics:

* [Datadog](https://developers.cloudflare.com/analytics/analytics-integrations/datadog/)
* [Graylog](https://developers.cloudflare.com/analytics/analytics-integrations/graylog/)
* [New Relic](https://developers.cloudflare.com/analytics/analytics-integrations/new-relic/)
* [Splunk](https://developers.cloudflare.com/analytics/analytics-integrations/splunk/)
* [Sentinel](https://developers.cloudflare.com/analytics/analytics-integrations/sentinel/)

## Cloudflare Network Interconnect

Connect your network infrastructure with Cloudflare [network connectivity partners](https://developers.cloudflare.com/network-interconnect/get-started/#connectivity-partners) for increased reliability and security.

## Cloudflare Zero Trust Technology Partners

Our third-party integrations allow you to deploy the WARP client application and configure devices remotely.

* [Fleet](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/fleet/)
* [Hexnode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/hexnode/)
* [Intune](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/intune/)
* [Jamf](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/jamf/)
* [JumpCloud](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/jumpcloud/)
* [Kandji](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/partners/kandji/)

## Cloudflare Logs

Enterprise customers have access to detailed logs of the metadata generated by our products, and logs from Cloudflare solutions can be pushed to a variety of log management providers and storage services.

* [Enable Cloudflare R2](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/r2/)
* [Enable HTTP destination](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/http/)
* [Enable Amazon S3](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/aws-s3/)
* [Enable S3-compatible endpoints](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/s3-compatible-endpoints/)
* [Enable Datadog](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/datadog/)
* [Enable Elastic](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/elastic/)
* [Enable Google Cloud Storage](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/google-cloud-storage/)
* [Enable BigQuery](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/bigquery/)
* [Enable Microsoft Azure](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/azure/)
* [Enable New Relic](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/new-relic/)
* [Enable Splunk](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/splunk/)
* [Enable Sumo Logic](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/sumo-logic/)
* [Enable Amazon Kinesis](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/kinesis/)
* [Enable IBM QRadar](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/ibm-qradar/)
* [Enable IBM Cloud Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/ibm-cloud-logs/)
* [Enable other providers](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/other-providers/)
* [Third-party integrations](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/third-party/)
* [Dedicated Egress IP for Logpush](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/egress-ip/)

## Cloudflare Technology Partners for Magic WAN

Cloudflare Magic WAN integrates with a number of third-party partners, which enables our users to securely route their Internet traffic.

* [Alibaba Cloud VPN Gateway](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/alibaba-cloud/)
* [Amazon AWS Transit Gateway](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/aws/)
* [Aruba EdgeConnect Enterprise](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/aruba-edgeconnect/)
* [Cisco IOS XE](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/cisco-ios-xe/)
* [Cisco SD-WAN](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/viptela/)
* [Fortinet](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/fortinet/)
* [Furukawa Electric FITELnet](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/fitelnet/)
* [Google Cloud VPN](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/google/)
* [Juniper Networks SRX Series Firewalls](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/juniper/)
* [Microsoft Azure](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/azure/)
* [Oracle Cloud](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/oracle/)
* [Palo Alto Networks NGFW](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/palo-alto/)
* [pfSense](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/pfsense/)
* [SonicWall](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/sonicwall/)
* [Sophos Firewall](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/sophos-firewall/)
* [strongSwan](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/strongswan/)
* [VyOS](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/vyos/)
