---
title: SDKs · Cloudflare Fundamentals docs
description: Cloudflare offers language software development kits (SDKs) as well
  as curl examples to demonstrate how to use the Cloudflare API. The SDK
  libraries allow you to interact with the Cloudflare API in language-specific
  syntax and more easily integrate with your existing applications.
lastUpdated: 2025-05-05T16:36:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/api/reference/sdks/
  md: https://developers.cloudflare.com/fundamentals/api/reference/sdks/index.md
---

Cloudflare offers language software development kits (SDKs) as well as `curl` examples to demonstrate how to use the Cloudflare API. The SDK libraries allow you to interact with the Cloudflare API in language-specific syntax and more easily integrate with your existing applications.

Cloudflare currently offers the following SDKs:

* [Go](https://github.com/cloudflare/cloudflare-go)
* [TypeScript](https://github.com/cloudflare/cloudflare-typescript)
* [Python](https://github.com/cloudflare/cloudflare-python)

## When to use cURL vs SDK

There is no definite answer on which you should use. Instead, consider your use case and determine whether cURL or an SDK is the best fit.

| Use case | cURL | SDK |
| - | - | - |
| Quick testing within the CLI | ✅ | ❌ |
| Use within bash scripts or CI | ✅ | ❌\* |
| Usage from within an existing application or framework | ❌ | ✅ |
| More complex usage where you need to chain together outputs | ❌ | ✅ |

\* It is possible, although not straight forward, to use the SDKs within bash scripts or CI environments with additional runtime dependencies and setup.

## Example

The following are examples of how you would query all of the Cloudflare zones you have access to.

### With cURL:

```bash
curl "https://api.cloudflare.com/client/v4/zones" \
--header "Authorization: Bearer <API_TOKEN>"
```

### With the TypeScript SDK:

```js
const client = new Cloudflare({
  apiToken: process.env["CLOUDFLARE_API_TOKEN"],
});


const zones = await client.zones.list();


console.log(zones);
```
