---
title: Account API tokens · Cloudflare Fundamentals docs
description: Learn what account API tokens are, when to use them, and what they
  currently work with
lastUpdated: 2025-10-02T15:57:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/api/get-started/account-owned-tokens/
  md: https://developers.cloudflare.com/fundamentals/api/get-started/account-owned-tokens/index.md
---

While user tokens act on behalf of a particular user and inherit a subset of that user's permissions, account API tokens allow you to set up durable integrations that can act as service principals with their own specific set of permissions. This approach is ideal for scenarios like CI/CD, or building integrations with external services like SEIMs where it is important that the integration continues working, even long after the user who configured the integration may have left your organization altogether. User tokens are better for ad hoc tasks like scripting, where acting as the user is ideal and durability is less of a concern.

## Create an account owned token

Note

Creating an account owned token requires Super Administrator permission on the account

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com).
2. Go to **Manage Account** > **Account API Tokens**.
3. Select **Create Token** and fill in the token name, permissions, and the optional expiration date for the token.
4. Select **Continue to summary** and review the details.
5. Select **Create Token**.

Alternatively, you can create a token using the [account API token creation API](https://developers.cloudflare.com/api/resources/accounts/subresources/tokens/methods/create/).

Refer to the [blog post](https://blog.cloudflare.com/account-owned-tokens-automated-actions-zaraz/) for more information.

## Compatibility matrix

Account API tokens are generally available for all accounts. Some services may not support account API tokens yet. Refer to the compatibility matrix below for the latest status.

| Product | Compatibility |
| - | - |
| Access | ✅ |
| Account Analytics | ✅ |
| Account Management | ✅ |
| AI Gateway | ✅ |
| AMP | ✅ |
| API Shield | ✅ |
| Argo | ✅ |
| Billing | ✅ |
| Cache | ✅ |
| Tiered Cache | ✅ |
| Cloud Connector | ✅ |
| Configuration Rules | ✅ |
| Custom Lists | ✅ |
| Custom Pages | ✅ |
| D1 | ✅ |
| Data Loss Prevention | ✅ |
| Digital Experience Monitoring | ✅ |
| Distributed Web | ✅ |
| DNS | ✅ |
| Durable Objects | ✅ |
| Email Relay | ✅ |
| Secure Web Gateway | ✅ |
| Healthchecks | ✅ |
| Hyperdrive | ✅ |
| Images | ✅ |
| Intel Data Platform | ❌ |
| Load Balancing | ✅ |
| Log Explorer | ✅ |
| Magic Network Monitoring | ✅ |
| Magic Transit | ✅ |
| Magic WAN | ✅ |
| Managed Rules | ✅ |
| Network Error Logging | ✅ |
| Page Rules | ❌ |
| Page Shield | ✅ |
| Pages | ✅ |
| Pub/Sub | ❌ |
| R2 | ✅ |
| Radar | ✅ |
| Registrar | ❌ |
| Rulesets | ✅ |
| Spectrum | ✅ |
| Speed | ✅ |
| SSL/TLS | ✅ |
| Stream | ✅ |
| Super Bot Fight Mode | ❌ |
| Trace | ✅ |
| Tunnels | ✅ |
| Turnstile | ❌ |
| Vectorize | ✅ |
| Waiting Room | ✅ |
| Workers | ✅ |
| Workers AI | ✅ |
| Workers KV | ✅ |
| Workers Observability | ✅ |
| Workers Queues | ✅ |
| Workflows | ✅ |
| Zaraz | ✅ |
| Zero Trust Client Platform | ❌ |
| Zero Trust Devices and Services | ✅ |
| Zone/Domain Management | ✅ |
