---
title: Managed service providers (MSPs) · Cloudflare Zero Trust docs
description: Gateway supports the Cloudflare Tenant API, which allows
  Cloudflare-partnered managed service providers (MSPs) to set up and manage
  Cloudflare accounts and services for their customers. With the Tenant API,
  MSPs can create Zero Trust deployments with global Gateway policy control.
  Policies can be customized or overridden at a group or individual account
  level.
lastUpdated: 2025-02-18T22:48:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/policies/gateway/managed-service-providers/
  md: https://developers.cloudflare.com/cloudflare-one/policies/gateway/managed-service-providers/index.md
---

Note

Only available on Enterprise plans. For more information, contact your account team.

Gateway supports the [Cloudflare Tenant API](https://developers.cloudflare.com/tenant/), which allows Cloudflare-partnered managed service providers (MSPs) to set up and manage Cloudflare accounts and services for their customers. With the Tenant API, MSPs can create Zero Trust deployments with global Gateway policy control. Policies can be customized or overridden at a group or individual account level.

The Tenant platform only supports [DNS policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/dns-policies/). For more information, refer to the [Cloudflare Zero Trust for managed service providers](https://blog.cloudflare.com/gateway-managed-service-provider/) blog post.

## Get started

To set up the Tenant API, refer to [Get started](https://developers.cloudflare.com/tenant/get-started/). Once you have provisioned and configured your customer's Cloudflare accounts, you can create [DNS policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/dns-policies/).

## Account types

The Gateway Tenant platform supports tiered and siloed account configurations.

### Tiered accounts

In a tiered account configuration, a top-level parent account enforces global security policies that apply to all of its child accounts. Child accounts can override or add policies as needed while still being managed by the parent account. MSPs can also configure child accounts independently from the parent account, including:

* Configuring a [custom block page](https://developers.cloudflare.com/cloudflare-one/policies/gateway/block-page/)
* Generating or uploading [root certificates](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/)
* Mapping [DNS locations](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/agentless/dns/locations/)
* Creating [lists](https://developers.cloudflare.com/cloudflare-one/policies/gateway/lists/)

Each child account is subject to the default Zero Trust [account limits](https://developers.cloudflare.com/cloudflare-one/account-limits/).

Gateway evaluates parent account policies before any child account policies. To allow a child account to override a specific parent account policy, you can use the [Update a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/update/) endpoint to set the policy's `allow_child_bypass` rule setting to `true`.

```mermaid
flowchart TD
%% Accessibility
 accTitle: How Gateway policies work in a tiered account configuration
 accDescr: Flowchart describing the order of precedence Gateway applies policies in a tiered account configuration.

%% Flowchart
 subgraph s1["Parent account"]
        n1["Block malware"]
        n2["Block DNS tunnel"]
        n3["Block spyware"]
  end
 subgraph s2["Child account A"]
        n4["Block social media"]
  end
 subgraph s3["Child account B"]
        n5["Block instant messaging"]
  end
    n1 ~~~ n2
    n2 ~~~ n3
    A["Tenant"] --Administers--> s1
    s1 -- "Applies policies to" --> s2 & s3

    n1@{ shape: lean-l}
    n2@{ shape: lean-l}
    n3@{ shape: lean-l}
    n4@{ shape: lean-l}
    n5@{ shape: lean-l}
```

### Siloed accounts

In a siloed account configuration, each account operates independently within the same tenant. MSPs manage each account's own security policies, resources, and configurations separately.

```mermaid
flowchart TD
%% Accessibility
 accTitle: How Gateway policies work in a siloed account configuration
 accDescr: Flowchart describing the order of precedence Gateway applies policies in a siloed account configuration.

%% Flowchart
 subgraph s1["Siloed account A"]
        n1["Block social media"]
  end
 subgraph s2["Siloed account C"]
        n2["Block instant messaing"]
  end
 subgraph s3["Siloed account B"]
        n3["Block news"]
  end
    A["Tenant"] -- Administers --> s1 & s3 & s2

    n1@{ shape: lean-l}
    n2@{ shape: lean-l}
    n3@{ shape: lean-l}
```
