---
title: WARP troubleshooting guide · Cloudflare Zero Trust docs
description: This guide helps you diagnose and resolve common issues with the
  Cloudflare WARP client. It covers how to troubleshoot the WARP client on
  desktop operating systems, including Windows, macOS, and Linux.
lastUpdated: 2025-09-17T14:04:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/index.md
---

This guide helps you diagnose and resolve common issues with the Cloudflare WARP client. It covers how to troubleshoot the WARP client on desktop operating systems, including Windows, macOS, and Linux.

1. **Before you start**: [Prerequisites](#prerequisites), permissions, [version control](#check-your-warp-version), and WARP basics.
2. **Collect logs**: Through the [dashboard](#option-a-collect-logs-via-the-cloudflare-dashboard) (with DEX remote capture) or the [command-line interface](#option-b-collect-logs-via-the-cli) (CLI) (`warp-diag`).
3. **Review logs**: [Status](#check-warp-status), [settings](#check-warp-settings), [profile ID](#profile-id), [split tunnel](#exclude-mode-with-hostsips) configuration, and other settings.
4. **Fix common misconfigurations**: [Profile mismatch](#wrong-profile-id), [split tunnel issues](#wrong-split-tunnel-configuration), [managed network issues](#review-your-managed-network-settings), [user group mismatch](#check-a-users-group-membership).
5. **File a support ticket**: [How to file a ticket](#5-file-a-support-ticket) after you have exhausted your troubleshooting options.

AI-assisted troubleshooting

Cloudflare One includes two free AI helpers to speed up WARP investigations:

[**WARP Diagnostics Analyzer**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/warp-logs/#warp-diagnostics-analyzer-beta) - Uses AI to parse a device’s WARP diagnostic log and summarizes key events, likely causes, and recommended next steps in a concise summary. This analyzer is available for logs collected via the dashboard.

[**DEX MCP server**](https://developers.cloudflare.com/cloudflare-one/insights/dex/dex-mcp-server/) — An AI tool that allows customers to ask a question like, "Show me the connectivity and performance metrics for the device used by carly‌@acme.com", and receive an answer that contains data from the DEX API.

## 1. Before you start

### Prerequisites

* You must have completed the [Zero Trust onboarding flow](https://developers.cloudflare.com/cloudflare-one/setup/) with a Zero Trust organization created.
* You must have the WARP client installed on an end user device.
* You must have a [role](https://developers.cloudflare.com/cloudflare-one/roles-permissions/) that gives admin permission to access logs on the Cloudflare dashboard.

### Check your WARP version

Many troubleshooting issues are caused by outdated client versions. For the best performance and compatibility, administrators should check for new releases and [update the WARP client](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/) before attempting to troubleshoot other issues.

After updating the WARP client, monitor the issue to see if it recurs. If the issue persists, continue with the troubleshooting guide.

#### Via the device

1. Open the WARP GUI on the desktop.
2. Select the gear icon.
3. Select **About WARP**.
4. Compare your device's version with the [latest version of WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/).

#### Via the Zero Trust dashboard

1. Log into [Zero Trust](https://one.dash.cloudflare.com/) > go to **My Team** > **Devices**.
2. Select the device you want to investigate.
3. Find the device's WARP version under **Client version** in the side menu.
4. Compare your device's version with the [latest version of WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/).

### WARP basics

Understand the WARP client’s architecture, installation paths, and modes to help you diagnose issues with greater accuracy.

#### WARP architecture

The WARP client consists of:

* **Graphical User Interface (GUI)**: Control panel that allows end users to view WARP's [status](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/connectivity-status/) and perform actions such as turning WARP on or off.
* **WARP daemon (or service)**: Core background component responsible for establishing secure tunnels (using WireGuard or MASQUE) and handling all WARP functionality on your device.

Refer to [WARP architecture](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/warp-architecture/) for more information on how the WARP client interacts with a device's operating system to route traffic.

#### WARP installation details

The GUI and daemon (or service) have different names and are stored in the following locations:

Windows

| | Windows |
| - | - |
| **Service / Daemon** | `C:\Program Files\Cloudflare\Cloudflare WARP\warp-svc.exe` |
| **GUI application** | `C:\Program Files\Cloudflare\Cloudflare WARP\Cloudflare WARP.exe` |
| **Logs Location** | Daemon`C:\ProgramData\Cloudflare\` GUI Logs`C:\Users\<USER>.WARP\AppData\Local` or `%LOCALAPPDATA%\Cloudflare` |

macOS

| | macOS |
| - | - |
| **Service / Daemon** | `/Applications/Cloudflare WARP.app/Contents/Resources/CloudflareWARP` |
| **GUI application** | `/Applications/Cloudflare WARP.app/Contents/MacOS/Cloudflare WARP` |
| **Logs Location** | Daemon`/Library/Application Support/Cloudflare/`GUI Logs`~/Library/Logs/Cloudflare/` |

Linux

| | Linux |
| - | - |
| **Service / Daemon** | `/bin/warp-svc` |
| **GUI application** | `/bin/warp-taskbar` |
| **Logs Location** | `/var/log/cloudflare-warp/` `/var/lib/cloudflare-warp` |

Along with the WARP GUI and daemon, `warp-cli` and `warp-diag` are also [installed](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/) on the machine and added to the system path for use from any terminal session.

[`warp-diag`](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/warp-logs/) is a command-line diagnostics tool that collects logs, configuration details, and connectivity data from the WARP client to help troubleshoot issues.

`warp-cli` is the command-line interface (CLI) for managing and configuring the Cloudflare WARP client, allowing users to connect, disconnect, and adjust settings programmatically.

#### WARP modes

WARP operates in several modes, each with different traffic handling capabilities:

Each WARP mode offers a different set of Zero Trust features.

| WARP Mode | DNS Filtering | Network Filtering | HTTP Filtering | Service mode (displayed in `warp-cli settings`) |
| - | - | - | - | - |
| [**Gateway with WARP (default)**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#gateway-with-warp-default) | ✅ | ✅ | ✅ | `WarpWithDnsOverHttps` |
| [**Gateway with DoH**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#gateway-with-doh) | ✅ | ❌ | ❌ | `DnsOverHttps` |
| [**Secure Web Gateway without DNS filtering**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#secure-web-gateway-without-dns-filtering) | ❌ | ✅ | ✅ | `TunnelOnly` |
| [**Proxy mode**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#proxy-mode) | ❌ | ❌ | ✅ | `WarpProxy` |
| [**Device Information Only**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#device-information-only) | ❌ | ❌ | ❌ | `PostureOnly` |

## 2. Collect diagnostic logs

You can collect diagnostic logs in two ways: the [Cloudflare dashboard](#option-a-collect-logs-via-the-cloudflare-dashboard) or the [`warp-diag`](#option-b-collect-logs-via-the-cli) command-line interface (CLI).

### Option A: Collect logs via the Cloudflare dashboard

Collect WARP diagnostic logs remotely from the Zero Trust dashboard by using Digital Experience Monitoring's (DEX) remote captures.

Best practice

To troubleshoot effectively, Cloudflare recommends reproducing the issue and noting your timestamps immediately before collecting logs. Though recreating the issue may not be possible in all cases, reproducing the issue right before WARP diag collection or during the window that a packet capture (PCAP) is running will help you troubleshoot with greater visibility.

Refer to [WARP log retention window](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/warp-logs/#log-retention-window) to learn more.

#### Start a remote capture

Devices must be actively connected to the Internet for remote captures to run.

To capture data from a remote device:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **DEX** > **Remote captures**.

2. Select up to 10 devices that you want to run a capture on. Devices must be [registered](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) in your Zero Trust organization.

3. Configure the types of captures to run.

   * **Packet captures (PCAP)**: Performs packet captures for traffic outside of the WARP tunnel (default network interface) and traffic inside of the WARP tunnel ([WARP virtual interface](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/warp-architecture/#ip-traffic)).

   * **WARP Diagnostics Logs**: Generates a [WARP diagnostic log](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/warp-logs/#warp-diag-logs) of the past 96 hours. To include a routing test for all IPs and domains in your [Split Tunnel configuration](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/), select **Test all routes**.

     Note

     **Test all routes** will extend the time for diagnostics to run and may temporarily impact device performance during the test.

     You must select WARP Diagnostic Logs. You can also choose to run a PCAP and reproduce the issue in the window the PCAP is running to gain further network insight. The scope of this troubleshooting covers only WARP diagnostic logs. If not choosing PCAPs, reproduce the issue right before running diagnostics.

4. Select **Run diagnostics**.

DEX will now send capture requests to the configured devices. If the WARP client is disconnected, the capture will time out after 10 minutes.

#### Check remote capture status

To view a list of captures, go to **DEX** > **Remote captures**. The **Status** column displays one of the following options:

* **Success**: The capture is complete and ready for download. Any partially successful captures will still upload to Cloudflare. For example, there could be a scenario where the PCAP succeeds on the primary network interface but fails on the WARP tunnel interface. You can [review PCAP results](https://developers.cloudflare.com/cloudflare-one/insights/dex/remote-captures/#download-remote-captures) to determine which PCAPs succeeded or failed.
* **Running**: The capture is in progress on the device.
* **Pending Upload**: The capture is complete but not yet ready for download.
* **Failed**: The capture has either timed out or encountered an error. To retry the capture, check the WARP client version and [connectivity status](https://developers.cloudflare.com/cloudflare-one/insights/dex/monitoring/#fleet-status), then start a [new capture](https://developers.cloudflare.com/cloudflare-one/insights/dex/remote-captures/#start-a-remote-capture).

#### Download remote captures

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **DEX** > **Remote captures**.
2. Find a successful capture.
3. Select the three-dot menu and select **Download**.

This will download a ZIP file to your local machine called `<capture-id>.zip`. DEX will store capture data according to our [log retention policy](https://developers.cloudflare.com/cloudflare-one/insights/logs/#log-retention).

After you have your diagnostic files, go to [Review key files](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#3-review-key-files) to continue troubleshooting.

AI-assisted troubleshooting

The [WARP Diagnostics Analyzer](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/warp-logs/#warp-diagnostics-analyzer-beta) uses AI to parse a device’s WARP diagnostic log and summarizes key events, likely causes, and recommended next steps in a concise summary.

After you run a [DEX remote capture](#option-a-collect-logs-via-the-cloudflare-dashboard) for WARP diagnostics:

1. Go to **DEX** > **Remote captures**.
2. Find your capture in the list of captures.
3. Select the three-dot icon next to **Status** > select **View WARP Diag** to generate an AI summary.

This analyzer is available for logs collected via the dashboard.

### Option B: Collect logs via the CLI

Collect WARP diagnostic logs on your desktop using the `warp-diag` CLI.

To view WARP logs on desktop devices:

* macOS

  1. Open a Terminal window.

  2. Run the `warp-diag` tool:

     ```sh
     warp-diag
     ```

  This will place a `warp-debugging-info-<date>-<time>.zip` on your desktop.

* Windows

  1. Open a Command Prompt or PowerShell window.

  2. Run the `warp-diag` tool:

     ```bash
     C:\Users\JohnDoe>warp-diag
     ```

  This will place a `warp-debugging-info-<date>-<time>.zip` on your desktop.

* Linux

  1. Open a Terminal window.

  2. Run the `warp-diag` tool:

     ```sh
     warp-diag
     ```

  This will place a `warp-debugging-info-<date>-<time>.zip` in the same folder you ran the command from.

Best practice

To troubleshoot effectively, Cloudflare recommends that you recreate the steps that cause the issue before running `warp-diag` and keep timestamps of your steps for review within the logs.

After you have your diagnostic files, go to [Review key files](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#3-review-key-files) to continue troubleshooting.

## 3. Review key files

WARP diagnostic logs capture the final WARP configuration and status on a device after all MDM policies and other software settings have been applied. Reviewing these logs can help you identify misconfigurations or unexpected behavior.

### Check WARP status

Open the `warp-status.txt` file to review the status of the WARP connection when the `warp-diag` was collected. A connected WARP client will appear as:

```plaintext
Ok(Connected)
```

If the WARP client is experiencing issues, the error will display in the WARP GUI on the device. Use the [Client errors](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/client-errors/) documentation to identify your error, its cause, and the solution.

### Check WARP settings

After you have checked WARP status, review WARP's settings on the device to check if the expected configuration has been applied. Open the `warp-settings.txt` file to review the WARP client settings. You will check the device's applied device profile and split tunnel configuration.

#### Example `warp-settings.txt` file

Find the WARP diagnostic logs on your desktop, and open the `warp-settings.txt` file. Review the following example `warp-settings.txt` file and the descriptions of its content below.

```txt
Merged configuration:
(derived)   Always On: true
(network policy)    Switch Locked: false # If false, does not allow the user to turn off the WARP toggle and disconnect the WARP client
(network policy)    Mode: WarpWithDnsOverHttps # The device's WARP mode, this mode is WARP with Gateway mode
(network policy)    WARP tunnel protocol: WireGuard
(default)   Disabled for Wifi: false
(default)   Disabled for Ethernet: false
(reg defaults)  Resolve via: 1xx0x1011xx000000000f0x00000x11.cloudflare-gateway.com @ [1xx.1xx.1x.1, 1x01:1x00:1x00::1xx1] # The SNI Cloudflare will use and the IP address for DNS-over-HTTPS (DoH) requests
(user set)  qlog logging: Enabled
(default)   Onboarding: true # If true, the user sees an onboarding prompt when they first install the WARP client
(network policy)    Exclude mode, with hosts/ips: # Split tunnel configuration
  1xx.1xx.1xx.1xx/25 (zoom)
...
  cname.user.net


(network policy)    Fallback domains: # Local domain fallback configuration
  intranet
...
  test
(not set)   Daemon Teams Auth: false
(network policy)    Disable Auto Fallback: false
(network policy)    Captive Portal: 180
(network policy)    Support URL: my-organizations-support-portal.com # Your organization's support portal or IT help desk
(user set)  Organization: Organization-Name
(network policy)    Allow Mode Switch: true  # The user is allowed to switch between WARP modes
(network policy)    Allow Updates: false # WARP client will not perform update checks
(network policy)    Allowed to Leave Org: true
(api defaults)  Known apple connectivity check IPs: xx.xxx.0.0/16;
(network policy)    LAN Access Settings: Allowed until reconnect on a /24 subnet # The maximum size of network that will be allowed when Access Lan is clicked.
(network policy)    Profile ID: 000000x1-00x1-1xx0-1xx1-11101x1axx11
```

Quick debugging

The command `warp-cli settings` in a terminal will generate the same information that is present in the `warp-settings.txt` file.

#### Contents of `warp-settings.txt` file

Review the meanings of the fields in `warp-settings.txt` that are relevant to troubleshooting.

##### Always On

Refers to the current state of the WARP toggle in the GUI. In the example file, the WARP toggle is switched on.

```txt
Always On: true
```

##### Switch Locked

Refers to the [Lock WARP Switch](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#lock-warp-switch) which allows the user to turn off the WARP switch and disconnect the client. In the example file, the value is `false` meaning the user is able to turn the WARP switch on or off at their discretion.

```txt
Switch Locked: false
```

When the Lock WARP switch is enabled (`true`), users will need an [Admin override](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#admin-override) code to temporarily turn off WARP on their device.

##### Mode

Refers to the [WARP mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/) the device is using. In the example file, the WARP mode is `WarpWithDnsOverHttps` which is Gateway with WARP mode. Refer to the [WARP modes comparison matrix](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/) to match your `warp-settings.txt` file's value with the mode name.

```txt
Mode: WarpWithDnsOverHttps
```

##### Exclude mode, with hosts/ips

Refers to your [split tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) settings. In the example file, WARP is running in Exclude mode, meaning all traffic except for the traffic destined for these hosts and IPs will be sent through the WARP tunnel. The host `cname.user.net` and the IP `1xx.1xx.1xx.1xx/25 `are both excluded from the WARP tunnel.

```txt
Exclude mode, with hosts/ips:
  1xx.1xx.1xx.1xx/25 (zoom)
...
  cname.user.net
```

Exclude mode versus Include mode

`Exclude mode` means all traffic will be sent through the WARP tunnel except for the IPs and domains you specify.

`Include mode` means only traffic destined to the IPs or domains you specify will be sent through the WARP tunnel.

##### Fallback domains

Refers to your [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/) settings. In the example file, WARP lists `intranet` as a domain that will not be sent to Gateway for processing and will instead be sent directly to the configured fallback servers.

```txt
(network policy)    Fallback domains:
  intranet
...
```

##### Allow Mode Switch

Refers to the [Mode switch](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#mode-switch) setting. In the example file, the mode switch is enabled (`true`) which means the user has the option to switch between [Gateway with WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#gateway-with-warp-default) mode and [Gateway with DNS-over-HTTPS (DoH)](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/#gateway-with-doh) mode.

```txt
Allow Mode Switch: true
```

##### Allow Updates

Refers to the [Allow updates](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#allow-updates) setting. In the example file, the allow updates setting is set to `false` meaning that the user will not receive update notifications when a new version of the WARP client is available and cannot update WARP without administrator approval.

```txt
Allow Updates: false
```

##### Allowed to Leave Org

Refers to the [Allow device to leave organization](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#allow-device-to-leave-organization) setting. In the example file, the value is set to `true` meaning the user can log out from your Zero Trust organization.

```txt
Allowed to Leave Org: true
```

##### LAN Access Settings

Refers to the [Allow users to enable local network exclusion](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#allow-users-to-enable-local-network-exclusion) setting. When enabled, it allows users to temporarily access local devices (like printers) by excluding the detected local subnet from the WARP tunnel. This example indicates access is allowed until the next WARP reconnection, and only for subnets up to `/24`.

```txt
LAN Access Settings: Allowed until reconnect on a /24 subnet
```

##### Profile ID

Refers to the [Device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) a device is using. In this example, the ID is `000000x1-00x1-1xx0-1xx1-11101x1axx11`.

```txt
Profile ID: 000000x1-00x1-1xx0-1xx1-11101x1axx11
```

## 4. Fix common misconfigurations

To verify that WARP is configured and working properly, review the following:

1. Is the [wrong profile ID](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#edit-your-device-profile-match-rules) applied to the device?
2. Is the [wrong split tunnel configuration](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#wrong-split-tunnel-configuration) active on the device?

### Wrong profile ID

A profile ID is a unique identifier assigned to each [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) in the Zero Trust dashboard, used to determine which configuration settings apply to a device.

#### Check the applied device profile

To check that the applied device profile is the intended device profile:

1. Go to [Zero Trust](https://one.dash.cloudflare.com/) > **Settings** > **WARP Client**.
2. Find and select the device profile intended for the device.
3. Under **Profile details**, compare the displayed **Profile ID** with the `Profile ID` in the `warp-settings.txt` file.

If your organization has multiple device profiles defined in the Zero Trust dashboard, a device may be matched to an unexpected profile because:

* How [profile precedence](#review-profile-precedence) is configured.
* [Managed network](#review-your-managed-network-settings) issues (if you are using a managed network.)
* User group [mismatch](#check-a-users-group-membership).
* Lack of [precise match rules](#edit-your-device-profile-match-rules).

#### Review profile precedence

Cloudflare WARP evaluates device profiles dynamically based on a hierarchy. When a device connects, WARP checks the profiles from top to bottom as they appear in the dashboard. WARP follows the first match principle — once a device matches a profile, WARP stops evaluating and no subsequent profiles can override the decision.

The **Default** profile is always at the bottom of the list. It will only be applied if the device does not meet the criteria of any profile listed above it. If you make another custom profile the default, all settings will be copied over into the **Default** profile.

Administrators can create multiple profiles to apply different settings based on specific criteria such as user identity, location, or operating system. Understanding this top-to-bottom evaluation order is crucial for ensuring that the correct policies are applied to devices.

Warning

Avoid [reordering profiles](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/#order-of-precedence) unless you are confident it will not affect other users.

#### Review your managed network settings

A [managed network](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/managed-networks/) is a network location that you define with a TLS endpoint, like a physical office. The WARP client checks for this TLS endpoint to determine its location and apply the corresponding device profile.

If the managed network is misconfigured or the TLS endpoint is unreachable, the device may fall back to an unintended profile.

When troubleshooting WARP for managed network issues:

1. Verify the endpoint is reachable.

   The WARP client connects to the TLS endpoint to identify the network. If the endpoint is down or unreachable, the WARP client will fail to detect the network and apply the wrong profile.

   To test connectivity and obtain the SHA-256 fingerprint of a remote server:

   ```sh
   openssl s_client -connect <private-server-IP>:443 < /dev/null 2> /dev/null | openssl x509 -noout -fingerprint -sha256 | tr -d :
   ```

   The output will look something like:

   ```txt
   SHA256 Fingerprint=DD4F4806C57A5BBAF1AA5B080F0541DA75DB468D0A1FE731310149500CCD8662
   ```

   If the endpoint is down, you will receive a `Could not find certificate from <stdin>` response.

   If you received a returned SHA-256 fingerprint:

   1. Log into [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.
   2. Go to **Manage Networks** > **Edit**.
   3. Compare the TLS Cert SHA-256 in the dashboard with the returned fingerprint in your terminal to ensure they match.

2. Use a single profile for a single location.

   To simplify management and prevent errors, avoid creating multiple managed network profiles for the same location. For example, if you have multiple TLS endpoints in one office, link them all to a single device profile. This reduces the risk of a device matching an unintended profile due to a configuration error.

#### Check a user's group membership

If a user is having issues with a device profile, it may be because they are not part of the correct user group. This can happen when an organization is not using SCIM for automatic identity provider (IdP) updates.

To check that the user belongs to the intended group:

1. Log into [Zero Trust](https://one.dash.cloudflare.com/) > go to **My Team** > **Users**.
2. Select the user.
3. Under **User Registry Identity**, select the user's name.
4. The **Get-identity endpoint** lists all the groups the user belongs to.

If the user was recently added to a group, they will need to update their group membership with Cloudflare Zero Trust. This can be accomplished by logging into the reauthenticate endpoint.

To manually refresh your Cloudflare Access session and update your group information from your identity provider (IdP), go to the following URL in your browser and fill in your [team name](https://developers.cloudflare.com/cloudflare-one/faq/getting-started-faq/#what-is-a-team-domainteam-name):

`https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/refresh-identity`

Reauthenticating resets your [session duration](https://developers.cloudflare.com/cloudflare-one/identity/users/session-management/) and fetches the latest group information from the organization's IdP.

#### Edit your device profile match rules

To modify the match rules of a device profile, you will need to edit the device profile. To edit the device profile:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.

2. In the **Profile settings** card, find the profile you want to update and select **Configure**.

3. Use [selectors](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/#selectors) to add or adjust match rules, and modify [WARP settings](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#device-settings) for this profile as needed.

   Note

   Changing any of the settings below will cause the WARP connection to restart. The user may experience a brief period of connectivity loss while the new settings are being applied.

   * [Service mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#service-mode)
   * [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#local-domain-fallback)
   * [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#split-tunnels)

4. Select **Save profile**.

It may take up to 10 minutes for newly updated settings to propagate to devices.

Note

Identity-based selectors are only available if the user [enrolled the device](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/manual-deployment/) by logging in to an identity provider (IdP).

### Wrong split tunnel configuration

Split Tunnels can be configured to exclude or include IP addresses or domains from going through WARP. This feature is commonly used to run WARP alongside a VPN (in Exclude mode) or to provide access to a specific private network (in Include mode).

Warning

Split Tunnels only impacts the flow of IP traffic. DNS requests are still resolved by Gateway and subject to DNS policies unless you add the domains to your [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/) configuration.

Because Split Tunnels controls what Gateway has visibility on at the network level, we recommend testing all changes before rolling out updates to end users.

A misconfigured [split tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) can cause connectivity issues.

For example, if you set your mode to Exclude IPs and domains and accidentally exclude an IP address needed by an application, that application may not work correctly. Similarly, in Include IPs and domains mode, forgetting to include a necessary IP or domain will cause traffic to bypass WARP, and you will lose access to your Zero Trust security features.

#### 1. Check the applied split tunnel configuration

After downloading the WARP diagnostic logs, review that your configuration is working as intended:

1. Open the `warp-settings.txt` file and find `Exclude mode, with hosts/ips:` or `Include mode, with hosts/ips:`.

   Exclude mode versus Include mode

   `Exclude mode` means all traffic will be sent through the WARP tunnel except for the IPs and domains you specify.

   `Include mode` means only traffic destined to the IPs or domains you specify will be sent through the WARP tunnel.

2. Log into [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP client**.

3. Find and select the device profile intended for the device.

4. Select **Edit**.

5. Find **Split Tunnels** and note the mode you have selected > select **Manage**.

6. Cross-reference the IPs/hosts you have configured in the Zero Trust dashboard with the IPs/hosts listed in `warp-settings.txt`.

If your dashboard split tunnel configuration does not match your `warp-settings.txt` file configuration, you may need to force the WARP client to [update its settings](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#update-the-warp-clients-settings).

#### 2. Update the WARP client's settings

If the split tunnel configuration in `warp-settings.txt` does not match the dashboard, you can force the WARP client to fetch the latest settings.

This can be done by instructing the end user to [toggle WARP off and on](#option-a-toggle-warp-off-and-back-on), or [reset their encryption keys](#option-b-reset-the-encryption-keys).

Both methods update the client with the latest configuration.

##### Option A: Toggle WARP off and back on

On the end user device, open the WARP GUI and toggle WARP on and off.

What if the end user cannot turn off WARP?

If the end user's [WARP switch](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#lock-warp-switch) is locked, they will need an [admin override code](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#admin-override) to be able to toggle the WARP switch.

[Resetting the encryption keys](#option-b-reset-the-encryption-keys) may be a faster solution.

After you toggle WARP back on, the WARP client will fetch new settings when it reconnects.

##### Option B: Reset the encryption keys

To reset the encryption keys on an end user's desktop:

1. Open the WARP GUI.
2. Select the gear icon.
3. Select **Preferences** > **Connection** > **Reset encryption keys**.

Resetting the encryption keys forces the WARP client to reestablish its tunnel and retrieve the latest configuration.

## 5. File a support ticket

Effective troubleshooting depends on clear, detailed support tickets. The more context you provide, the faster support can identify and resolve the issue.

To ensure efficient resolution when [contacting support](https://developers.cloudflare.com/support/contacting-cloudflare-support/), include as much relevant detail as possible in your ticket:

*
*
*
*
*

Avoid vague ticket descriptions

Refer to the following example of a vague ticket description:

Ken was on the train and had captive portal issues. `warp-diag` is attached.

Include scenario, timestamps, and steps taken to troubleshoot the issue

Refer to the following example of an ideal ticket description:

Karen was on a train on July 17, 2025, at approximately 1:00 PM Central Time. She attempted to connect to a captive portal but received the following error message in Chrome: `ERR_CONNECTION_RESET`. A warp diag was collected immediately after and is attached.
