---
title: Challenge Passage · Cloudflare challenges docs
description: When a visitor solves a Cloudflare Challenge - as part of a WAF
  custom rule or IP Access rule - you can set the Challenge Passage to prevent
  them from having to solve future Challenges for a specified period of time.
lastUpdated: 2025-09-26T21:09:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/challenge-passage/
  md: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/challenge-passage/index.md
---

When a visitor solves a [Cloudflare Challenge](https://developers.cloudflare.com/cloudflare-challenges/) - as part of a [WAF custom rule](https://developers.cloudflare.com/waf/custom-rules/) or [IP Access rule](https://developers.cloudflare.com/waf/tools/ip-access-rules/) - you can set the **Challenge Passage** to prevent them from having to solve future Challenges for a specified period of time.

### How it works

When a visitor successfully solves a Challenge, Cloudflare sets a [`cf_clearance` cookie](https://developers.cloudflare.com/fundamentals/reference/policies-compliances/cloudflare-cookies/#additional-cookies-used-by-the-challenge-platform) in their browser. This cookie specifies the duration your website is accessible to that visitor.

When that visitor tries to access other parts of your website, Cloudflare evaluates the cookie before presenting another Challenge. If the cookie is still valid, no Challenges will be shown.

When Cloudflare evaluates a `cf_clearance` cookie, a few extra minutes are included to account for clock skew. For XmlHTTP requests, an extra hour is added to the validation time to prevent breaking XmlHTTP requests for pages that set short lifetimes.

### Customize the Challenge Passage

By default, the `cf_clearance` cookie has a lifetime of 30 minutes. Cloudflare recommends a setting between 15 and 45 minutes.

To update the Challenge Passage (and the value of the `cf_clearance` cookie):

1. In the Cloudflare dashboard, go to the **Security Settings** page.

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/security/settings)

2. Go to **Challenge passage**.

3. Select the edit icon to set a timeout duration.

### Limitations

The Challenge Passage does not apply to Challenges issued by [WAF managed rules](https://developers.cloudflare.com/waf/managed-rules/). Also, Challenge Passage does not apply to rate limiting rules unless the rate limit is configured to issue a Challenge.
