---
title: Global Acceleration · Cloudflare China Network docs
description: Global Acceleration is a suite of connectivity, performance
  offerings and professional services designed to simplify your global assets'
  deployment in China. Global Acceleration is provided by our partners including
  CMI, CBC Tech, and JD Cloud.
lastUpdated: 2025-09-25T09:00:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/china-network/concepts/global-acceleration/
  md: https://developers.cloudflare.com/china-network/concepts/global-acceleration/index.md
---

Note

Global Acceleration is a service offering that can be an add-on to China Network and also extends Zero Trust services into China.

Global Acceleration is a suite of connectivity, performance offerings and professional services designed to simplify your global assets' deployment in China. Global Acceleration is provided by our partners including CMI, CBC Tech, and JD Cloud.

Depending on what fits your needs best, Global Acceleration can support the following scenarios:

| Service | Scenario |
| - | - |
| [CDN Global Acceleration](#cdn-global-acceleration) | Elevated performance of global dynamic assets on China Network CDN. |
| [WARP Global Acceleration](#warp-global-acceleration) | WARP client used in Mainland China. |
| [Magic WAN Global Acceleration](#magic-wan-global-acceleration) | Magic WAN used in Mainland China. |
| [ICP](#icp-services) | China Network prerequisite. |
| [MLPS](#mlps-services) | MLPS certification services. |
| [Travel SIM](#travel-sim) | Zero Trust clients in business traveling to Mainland China. |

## CDN Global Acceleration

CDN Global Acceleration provides stable and reliable connections for dynamic content entering and exiting China, specifically beneficial for users' experience within the country. Additionally, this service can help facilitate seamless dynamic traffic management, ensuring stable connectivity across multiple global origins. It can also support more advanced scenarios of Cloudflare features such as Cloudflare R2 and Cloudflare Fonts in China.

## WARP Global Acceleration

WARP Global Acceleration is a verified solution for enabling [WARP client](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/) access within China, allowing remote employees to maintain secure and consistent connections.

## Magic WAN Global Acceleration

Magic WAN Global Acceleration is a verified solution for enabling [Magic WAN](https://developers.cloudflare.com/magic-wan/) access within China, allowing in-office employees to maintain secure and reliable connectivity.

## ICP services

Internet Content Provider (ICP) service simplifies the complexities of acquiring an ICP for domains to operate compliantly within China.

## MLPS services

The Multi-Level Protection Scheme (MLPS) service add-on streamlines the certification process to secure the MLPS L3 certification for your applications.

### Travel SIM

Travel SIM offers temporary, seamless WARP access for individual employees traveling to China, ensuring uninterrupted connectivity during their visit.

***

## General process

### 1. Validate prerequisites

Ensure that you have a Cloudflare [Enterprise plan](https://www.cloudflare.com/plans/enterprise/) and [China Network](https://developers.cloudflare.com/china-network/), if you want CDN Global Acceleration or other offers. Licenses of WARP and Magic WAN are required for WARP Connection or Magic WAN Global Acceleration.

### 2. Sign contract

Contact your Cloudflare account team. They will assist you with contracting with us, or our local China partners, depending on the service.

### 3. Deploy Global Acceleration

Our local China partners will assist you to deploy Global Acceleration.
