---
title: WARP client for macOS (version 2025.4.929.0) · Changelog
description: WARP client for macOS (version 2025.4.929.0)
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-12-warp-macos-ga/
  md: https://developers.cloudflare.com/changelog/2025-05-12-warp-macos-ga/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## WARP client for macOS (version 2025.4.929.0)

May 12, 2025

[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/)

A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/).

This release contains two significant changes all customers should be aware of:

1. All DNS traffic now flows inside the WARP tunnel. Customers are no longer required to configure their local firewall rules to allow our [DoH IP addresses and domains](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/firewall/#doh-ip).
2. When using MASQUE, the connection will fall back to HTTP/2 (TCP) when we detect that HTTP/3 traffic is blocked. This allows for a much more reliable connection on some public WiFi networks.

**Changes and improvements**

* Fixed an issue where the managed network policies could incorrectly report network location beacons as missing.
* Improved DEX test error reporting.
* Fixed an issue causing client notifications to fail in IPv6 only environments which prevented the client from receiving configuration changes to settings like device profile.
* Improved captive portal detection.
* Added a TCP fallback for the MASQUE tunnel protocol to improve connectivity on networks that block UDP or HTTP/3 specifically.
* Added new IP addresses for [tunnel connectivity checks](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/firewall/#connectivity-checks). If your organization uses a firewall or other policies you will need to exempt these IPs.
* DNS over HTTPS traffic is now included in the WARP tunnel by default.
* Improved the error message displayed in the client GUI when the rate limit for entering an incorrect admin override code is met.
* Improved handling of non-SLAAC IPv6 interface addresses for better connectivity in IPv6 only environments.
* Fixed an issue where frequent network changes could cause WARP to become unresponsive.
* Improvement for WARP to check if tunnel connectivity fails or times out at device wake before attempting to reconnect.
* Fixed an issue causing WARP connection disruptions after network changes.

**Known issues**

* macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
