---
title: Cron triggers are now supported in Python Workers · Changelog
description: You can now set up scheduled handlers in your Python Workers
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-22-python-worker-cron-triggers/
  md: https://developers.cloudflare.com/changelog/2025-04-22-python-worker-cron-triggers/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Cron triggers are now supported in Python Workers

Apr 24, 2025

[Workers](https://developers.cloudflare.com/workers/)

You can now create Python Workers which are executed via a cron trigger.

This is similar to how it's done in JavaScript Workers, simply define a scheduled event listener in your Worker:

```python
from workers import handler


@handler
async def on_scheduled(event, env, ctx):
  print("cron processed")
```

Define a cron trigger configuration in your Wrangler configuration file:

* wrangler.jsonc

  ```jsonc
  {
    "triggers": {
      "crons": [
        "*/3 * * * *",
        "0 15 1 * *",
        "59 23 LW * *"
      ]
    }
  }
  ```

* wrangler.toml

  ```toml
  [triggers]
  # Schedule cron triggers:
  # - At every 3rd minute
  # - At 15:00 (UTC) on first day of the month
  # - At 23:59 (UTC) on the last weekday of the month
  crons = [ "*/3 * * * *", "0 15 1 * *", "59 23 LW * *" ]
  ```

Then test your new handler by using Wrangler with the `--test-scheduled` flag and making a request to `/cdn-cgi/handler/scheduled?cron=*+*+*+*+*`:

```sh
npx wrangler dev --test-scheduled


curl "http://localhost:8787/cdn-cgi/handler/scheduled?cron=*+*+*+*+*"
```

Consult the [Workers Cron Triggers page](https://developers.cloudflare.com/workers/configuration/cron-triggers/) for full details on cron triggers in Workers.
