---
title: Signals Intelligence · Cloudflare bot solutions docs
description: For every available JA4 fingerprint, Bot Management customers can
  view how Cloudflare sees it on the Internet and what behavior we view with the
  fingerprint. This data can help you understand why a request is scored in a
  particular fashion or allow you to use the aggregate data in your own ML
  models, run in either Cloudflare Workers or at the origin location.
lastUpdated: 2025-08-20T18:25:25.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/signals-intelligence/
  md: https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/signals-intelligence/index.md
---

For every available [JA4 fingerprint](https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/), Bot Management customers can view how Cloudflare sees it on the Internet and what behavior we view with the fingerprint. This data can help you understand why a request is scored in a particular fashion or allow you to use the aggregate data in your own ML models, run in either [Cloudflare Workers](https://developers.cloudflare.com/workers/) or at the origin location.

Specifically, for each JA4 fingerprint, you will be able to access the following information:

* The percentage of traffic associated with browsers that Cloudflare sees.
* The percentage of traffic associated with known bots that Cloudflare sees.
* The number of networks Cloudflare sees actively using this fingerprint.
* The number of Cloudflare sites that see traffic from this fingerprint.
* The frequency that fingerprint requests caches content and generates errors.

This data gives you access to insights only available via the Cloudflare network and generated by our unique edge network that sits behind 20% of all internet traffic. Additionally, you can feed this data into your own [Workers AI](https://developers.cloudflare.com/workers-ai/)-powered custom machine learning models via the Signals Intelligence fields below.

## Signals Intelligence fields

Signals Intelligence fields show observations about a particular JA4 that Cloudflare has seen globally over the last hour.

| Field name | Description |
| - | - |
| `h2h3_ratio_1h` | The ratio of HTTP/2 and HTTP/3 requests combined with the total number of requests for the JA4 fingerprint in the last hour. Higher values indicate a higher proportion of HTTP/2 and HTTP/3 requests compared to other protocol versions. |
| `heuristic_ratio_1h` | The ratio of requests with a `scoreSrc` value of "heuristics" for the JA4 fingerprint in the last hour. Higher values suggest a larger proportion of requests being flagged by heuristic-based scoring. |
| `reqs_quantile_1h` | The quantile position of the JA4 fingerprint based on the number of requests across all fingerprints in the last hour. Higher values indicate a relatively higher number of requests compared to other fingerprints. |
| `uas_rank_1h` | The rank of the JA4 fingerprint based on the number of distinct user agents across all fingerprints in the last hour. Lower values indicate a higher diversity of user agents associated with the fingerprint. |
| `browser_ratio_1h` | The ratio of requests originating from browser-based user agents for the JA4 fingerprint in the last hour. Higher values suggest a higher proportion of browser-based requests. |
| `paths_rank_1h` | The rank of the JA4 fingerprint based on the number of unique request paths across all fingerprints in the last hour. Lower values indicate a higher diversity of request paths associated with the fingerprint. |
| `reqs_rank_1h` | The rank of the JA4 fingerprint based on the number of requests across all fingerprints in the last hour. Lower values indicate a higher number of requests associated with the fingerprint. |
| `cache_ratio_1h` | The ratio of cacheable responses for the JA4 fingerprint in the last hour. Higher values suggest a higher proportion of responses that can be cached. |
| `ips_rank_1h` | The rank of the JA4 fingerprint based on the number of unique client IP addresses across all fingerprints in the last hour. Lower values indicate a higher number of distinct client IPs associated with the fingerprint. |
| `ips_quantile_1h` | The quantile position of the JA4 fingerprint based on the number of unique client IP addresses across all fingerprints in the last hour. Higher values indicate a relatively higher number of distinct client IPs compared to other fingerprints. |

If you want to use JA4 fingerprints and Signals Intelligence, your Workers script must be able to handle the absence of any field in the array, including:

* The possibility that the JA4 fingerprint could be missing.
* The possibility that the `ja4Signals` array could be missing.
* Results with `NaN` or `Infinity` values will be excluded from the array.
