---
title: Deprecations · Cloudflare Workers docs
description: The differences between Wrangler versions, specifically
  deprecations and breaking changes.
lastUpdated: 2025-03-13T11:08:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/wrangler/deprecations/
  md: https://developers.cloudflare.com/workers/wrangler/deprecations/index.md
---

Review the difference between Wrangler versions, specifically deprecations and breaking changes.

## Wrangler v4

### Workers Sites

Usage of [Workers Sites](https://developers.cloudflare.com/workers/wrangler/configuration/#workers-sites) is deprecated. Instead, we recommend migrating to [Workers Static Assets](https://developers.cloudflare.com/workers/static-assets/). Support for using Workers Sites with Wrangler will be removed in a future version of Wrangler.

### Service environments

Usage of [Service Environments](https://blog.cloudflare.com/introducing-worker-services/#services-have-environments), enabled via the `legacy_env` property in Wrangler config, is deprecated. Instead, we recommend migrating to [Wrangler Environments](https://developers.cloudflare.com/workers/wrangler/configuration/#environments). Support for using Service Environments with Wrangler will be removed in a future version of Wrangler.

## Wrangler v3

### Deprecated commands

The following commands are deprecated in Wrangler as of Wrangler v3. These commands will be fully removed in a future version of Wrangler.

#### `generate`

The `wrangler generate` command is deprecated, but still active in v3. `wrangler generate` will be fully removed in v4.

Use `npm create cloudflare@latest` for new Workers and Pages projects.

#### `publish`

The `wrangler publish` command is deprecated, but still active in v3. `wrangler publish` will be fully removed in v4.

Use [`npx wrangler deploy`](https://developers.cloudflare.com/workers/wrangler/commands/#deploy) to deploy Workers.

#### `pages publish`

The `wrangler pages publish` command is deprecated, but still active in v3. `wrangler pages publish` will be fully removed in v4.

Use [`wrangler pages deploy`](https://developers.cloudflare.com/workers/wrangler/commands/#deploy-1) to deploy Pages.

#### `version`

Instead, use `wrangler --version` to check the current version of Wrangler.

### Deprecated options

#### `--experimental-local`

`wrangler dev` in v3 is local by default so this option is no longer necessary.

#### `--local`

`wrangler dev` in v3 is local by default so this option is no longer necessary.

#### `--persist`

`wrangler dev` automatically persists data by default so this option is no longer necessary.

#### `-- <command>`, `--proxy`, and `--script-path` in `wrangler pages dev`

These options prevent `wrangler pages dev` from being able to accurately emulate production's behavior for serving static assets and have therefore been deprecated. Instead of relying on Wrangler to proxy through to some other upstream dev server, you can emulate a more accurate behavior by building your static assets to a directory and pointing Wrangler to that directory with `wrangler pages dev <directory>`.

#### `--legacy-assets` and the `legacy_assets` config file property

We recommend you [migrate to Workers assets](https://developers.cloudflare.com/workers/static-assets/)

#### `--node-compat` and the `node_compat` config file property

Instead, use the [`nodejs_compat` compatibility flag](https://developers.cloudflare.com/workers/runtime-apis/nodejs). This includes the functionality from legacy `node_compat` polyfills and natively implemented Node.js APIs.

#### The `usage_model` config file property

This no longer has any effect, after the [rollout of Workers Standard Pricing](https://blog.cloudflare.com/workers-pricing-scale-to-zero/).

## Wrangler v2

Wrangler v2 introduces new fields for configuration and new features for developing and deploying a Worker, while deprecating some redundant fields.

* `wrangler.toml` is no longer mandatory.
* `dev` and `publish` accept CLI arguments.
* `tail` can be run on arbitrary Worker names.
* `init` creates a project boilerplate.
* JSON bindings for `vars`.
* Local mode for `wrangler dev`.
* Module system (for both modules and service worker format Workers).
* DevTools.
* TypeScript support.
* Sharing development environment on the Internet.
* Wider platform compatibility.
* Developer hotkeys.
* Better configuration validation.

The following video describes some of the major changes in Wrangler v2, and shows you how Wrangler v2 can help speed up your workflow.

### Common deprecations

Refer to the following list for common fields that are no longer required.

* `type` is no longer required. Wrangler will infer the correct project type automatically.
* `zone_id` is no longer required. It can be deduced from the routes directly.
* `build.upload.format` is no longer used. The format is now inferred automatically from the code.
* `build.upload.main` and `build.upload.dir` are no longer required. Use the top level `main` field, which now serves as the entry-point for the Worker.
* `site.entry-point` is no longer required. The entry point should be specified through the `main` field.
* `webpack_config` and `webpack` properties are no longer supported. Refer to [Migrate webpack projects from Wrangler version 1](https://developers.cloudflare.com/workers/wrangler/migration/v1-to-v2/eject-webpack/). Here are the Wrangler v1 commands that are no longer supported:
* `wrangler preview` - Use the `wrangler dev` command, for running your worker in your local environment.
* `wrangler generate` - If you want to use a starter template, clone its GitHub repository and manually initialize it.
* `wrangler route` - Routes are defined in the [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/).
* `wrangler report` - If you find a bug, report it at [Wrangler issues](https://github.com/cloudflare/workers-sdk/issues/new/choose).
* `wrangler build` - If you wish to access the output from bundling your Worker, use `wrangler publish --outdir=path/to/output`.

#### New fields

These are new fields that can be added to your [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/).

* **`main`**: `string`, optional

  The `main` field is used to specify an entry point to the Worker. It may be in the established service worker format, or the newer, preferred modules format. An entry point is now explicitly required, and can be configured either via the `main` field, or passed directly as a command line, for example, `wrangler dev index.js`. This field replaces the legacy `build.upload.main` field (which only applied to modules format Workers).

* **`rules`**: `array`, optional

  The `rules` field is an array of mappings between module types and file patterns. It instructs Wrangler to interpret specific files differently than JavaScript. For example, this is useful for reading text-like content as text files, or compiled WASM as ready to instantiate and execute. These rules can apply to Workers of both the established service worker format, and the newer modules format. This field replaces the legacy `build.upload.rules` field (which only applied to modules format Workers).

#### Non-mandatory fields

A few configuration fields which were previously required, are now optional in particular situations. They can either be inferred, or added as an optimization. No fields are required anymore when starting with Wrangler v2, and you can gradually add configuration as the need arises.

* **`name`**: `string`

  The `name` configuration field is now not required for `wrangler dev`, or any of the `wrangler kv:*` commands. Further, it can also be passed as a command line argument as `--name <name>`. It is still required for `wrangler publish`.

* **`account_id`**: `string`

  The `account_id` field is not required for any of the commands. Any relevant commands will check if you are logged in, and if not, will prompt you to log in. Once logged in, it will use your account ID and will not prompt you again until your login session expires. If you have multiple account IDs, you will be presented with a list of accounts to choose from.

  You can still configure `account_id` in your Wrangler file, or as an environment variable `CLOUDFLARE_ACCOUNT_ID`. This makes startup faster and bypasses the list of choices if you have multiple IDs. The `CLOUDFLARE_API_TOKEN` environment variable is also useful for situations where it is not possible to login interactively. To learn more, visit [Running in CI/CD](https://developers.cloudflare.com/workers/ci-cd/external-cicd/).

* **`workers_dev`** `boolean`, default: `true` when no routes are present

  The `workers_dev` field is used to indicate that the Worker should be published to a `*.workers.dev` subdomain. For example, for a Worker named `my-worker` and a previously configured `*.workers.dev` subdomain `username`, the Worker will get published to `my-worker.username.workers.dev.com`. This field is not mandatory, and defaults to `true` when `route` or `routes` are not configured. When routes are present, it defaults to `false`. If you want to neither publish it to a `*.workers.dev` subdomain nor any routes, set `workers_dev` to `false`. This useful when you are publishing a Worker as a standalone service that can only be accessed from another Worker with (`services`).

#### Deprecated fields (non-breaking)

A few configuration fields are deprecated, but their presence is not a breaking change yet. It is recommended to read the warning messages and follow the instructions to migrate to the new configuration. They will be removed and stop working in a future version.

* **`zone_id`**: `string`, deprecated

  The `zone_id` field is deprecated and will be removed in a future release. It is now inferred from `route`/`routes`, and optionally from `dev.host` when using `wrangler dev`. This also makes it simpler to deploy a single Worker to multiple domains.

* **`build.upload`**: `object`, deprecated

  The `build.upload` field is deprecated and will be removed in a future release. Its usage results in a warning with suggestions on rewriting the configuration file to remove the warnings.

  * `build.upload.main`/`build.upload.dir` are replaced by the `main` fields and are applicable to both service worker format and modules format Workers.
  * `build.upload.rules` is replaced by the `rules` field and is applicable to both service worker format and modules format Workers.
  * `build.upload.format` is no longer specified and is automatically inferred by `wrangler`.

#### Deprecated fields (breaking)

A few configuration fields are deprecated and will not work as expected anymore. It is recommended to read the error messages and follow the instructions to migrate to the new configuration.

* **`site.entry-point`**: `string`, deprecated

  The `site.entry-point` configuration was used to specify an entry point for Workers with a `[site]` configuration. This has been replaced by the top-level `main` field.

* **`type`**: `rust` | `javascript` | `webpack`, deprecated

  The `type` configuration was used to specify the type of Worker. It has since been made redundant and is now inferred from usage. If you were using `type = "webpack"` (and the optional `webpack_config` field), you should read the [webpack migration guide](https://developers.cloudflare.com/workers/wrangler/migration/v1-to-v2/eject-webpack/) to modify your project and use a custom build instead.

### Deprecated commands

The following commands are deprecated in Wrangler as of Wrangler v2.

#### `build`

The `wrangler build` command is no longer available for building the Worker.

The equivalent functionality can be achieved by `wrangler publish --dry-run --outdir=path/to/build`.

#### `config`

The `wrangler config` command is no longer available for authenticating via an API token.

Use `wrangler login` / `wrangler logout` to manage OAuth authentication, or provide an API token via the `CLOUDFLARE_API_TOKEN` environment variable.

#### `preview`

The `wrangler preview` command is no longer available for creating a temporary preview instance of the Worker.

Try using `wrangler dev` to try out a worker during development.

#### subdomain

The `wrangler subdomain` command is no longer available for creating a `workers.dev` subdomain.

Create the `workers.dev` subdomain in **Workers & Pages** > select your Worker > Your subdomain > **Change**.

#### route

The `wrangler route` command is no longer available to configure a route for a Worker.

Routes are specified in the [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/).

### Other deprecated behavior

* Cloudflare dashboard-defined routes will not be added alongside Wrangler-defined routes. Wrangler-defined routes are the `route` or `routes` key in your `wrangler.toml`. If both are defined, only routes defined in `wrangler.toml` will be valid. To manage routes via the Cloudflare dashboard only, remove any `route` and `routes` keys from and add `workers_dev = false` to your Wrangler file.

* Wrangler will no longer use `index.js` in the directory where `wrangler dev` is called as the entry point to a Worker. Use the `main` configuration field, or explicitly pass it as a command line argument, for example: `wrangler dev index.js`.

* Wrangler will no longer assume that bare specifiers are file names if they are not represented as a path. For example, in a folder like so:

  ```plaintext
  project
  ├── index.js
  └── some-dependency.js
  ```

  where the content of `index.js` is:

  ```js
  import SomeDependency from "some-dependency.js";


  addEventListener("fetch", (event) => {
    // ...
  });
  ```

  Wrangler v1 would resolve `import SomeDependency from "some-dependency.js";` to the file `some-dependency.js`. This will also work in Wrangler v2, but will also log a deprecation warning. In the future, this will break with an error. Instead, you should rewrite the import to specify that it is a relative path, like so:

  ```diff
  import SomeDependency from "some-dependency.js";
  import SomeDependency from "./some-dependency.js";
  ```

### Wrangler v1 and v2 comparison tables

#### Commands

| Command | v1 | v2 | Notes |
| - | - | - | - |
| `publish` | ✅ | ✅ | |
| `dev` | ✅ | ✅ | |
| `preview` | ✅ | ❌ | Removed, use `dev` instead. |
| `init` | ✅ | ✅ | |
| `generate` | ✅ | ❌ | Removed, use `git clone` instead. |
| `build` | ✅ | ❌ | Removed, invoke your own build script instead. |
| `secret` | ✅ | ✅ | |
| `route` | ✅ | ❌ | Removed, use `publish` instead. |
| `tail` | ✅ | ✅ | |
| `kv` | ✅ | ✅ | |
| `r2` | 🚧 | ✅ | Introduced in Wrangler v1.19.8. |
| `pages` | ❌ | ✅ | |
| `config` | ✅ | ❓ | |
| `login` | ✅ | ✅ | |
| `logout` | ✅ | ✅ | |
| `whoami` | ✅ | ✅ | |
| `subdomain` | ✅ | ❓ | |
| `report` | ✅ | ❌ | Removed, error reports are made interactively. |

#### Configuration

| Property | v1 | v2 | Notes |
| - | - | - | - |
| `type = "webpack"` | ✅ | ❌ | Removed, refer to [this guide](https://developers.cloudflare.com/workers/wrangler/migration/v1-to-v2/eject-webpack/) to migrate. |
| `type = "rust"` | ✅ | ❌ | Removed, use [`workers-rs`](https://github.com/cloudflare/workers-rs) instead. |
| `type = "javascript"` | ✅ | 🚧 | No longer required, can be omitted. |

#### Features

| Feature | v1 | v2 | Notes |
| - | - | - | - |
| TypeScript | ❌ | ✅ | You can give wrangler a TypeScript file, and it will automatically transpile it to JavaScript using [`esbuild`](https://github.com/evanw/esbuild) under-the-hood. |
| Local mode | ❌ | ✅ | `wrangler dev --local` will run your Worker on your local machine instead of on our network. This is powered by [Miniflare](https://github.com/cloudflare/workers-sdk/tree/main/packages/miniflare/). |
