---
title: Get tenant details · Cloudflare Tenant docs
description: A Tenant Admin's unit and membership details will be used for
  access of resources and all Tenant operations on the API. The unit ID
  (unit_tag), for example, can be used to create an account on a specific unit.
lastUpdated: 2025-08-20T20:59:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/tenant/how-to/get-tenant-details/
  md: https://developers.cloudflare.com/tenant/how-to/get-tenant-details/index.md
---

A [**Tenant Admin**](https://developers.cloudflare.com/tenant/glossary/#tenant-admin)'s unit and membership details will be used for access of resources and all Tenant operations on the API. The unit ID (`unit_tag`), for example, can be used to create an account on a specific unit.

This is especially useful when a Tenant Admin has multiple units and wants to create an account on a specific unit. All accounts created are associated with the units, each of which can have one or more memberships.

To retrieve tenant details, send a `GET` request to the `/user/tenants` endpoint:

```bash
curl "https://api.cloudflare.com/client/v4/user/tenants" \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>"
```

A successful request will return an HTTP status of `200` and a response body containing tenant information, unit information, memberships, and tenant entitlements for all tenants administered by the user.
