---
title: Error 1014 · Cloudflare Support docs
description: This error indicates that a CNAME record between domains in
  different Cloudflare accounts is prohibited.
lastUpdated: 2025-06-16T14:59:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1014/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1014/index.md
---

## Error 1014: CNAME Cross-User Banned

This error indicates that a CNAME record between domains in different Cloudflare accounts is prohibited.

### Common cause

By default, Cloudflare prohibits a DNS CNAME record between domains in different Cloudflare accounts. CNAME records are permitted within a domain ([`www.example.com`](http://www.example.com) CNAME to `api.example.com`) and across zones within the same user account ([`www.example.com`](http://www.example.com) CNAME to [`www.example.net`](http://www.example.net)) or using our [Cloudflare for SaaS](https://www.cloudflare.com/saas/) solution.

Another common cause is connecting a custom domain to an R2 bucket, where the domain is an active zone with the [zone hold](https://developers.cloudflare.com/fundamentals/account/account-security/zone-holds/) feature enabled.

### Resolution

* To allow CNAME record resolution to a domain in a different Cloudflare account, the domain owner of the CNAME target must use [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/).
* To allow connecting to a R2 bucket with a custom domain, disable the [zone hold](https://developers.cloudflare.com/fundamentals/account/account-security/zone-holds/) feature on the custom domain target zone to resolve the 1014 error.
