---
title: How to select a content type · Cloudflare Style Guide
description: As the Cloudflare docs have grown, we've added content types that
  can be hard to differentiate from each other. The Cloudflare docs team does
  not expect customers to know the nuances between these content type, but we
  define similar content types in specific ways for formatting, maintenance, and
  analytic tracking reasons.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/select-content-type/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/select-content-type/index.md
---

As the Cloudflare docs have grown, we've added content types that can be hard to differentiate from each other. The Cloudflare docs team does not expect customers to know the nuances between these content type, but we define similar content types in specific ways for formatting, maintenance, and analytic tracking reasons.

This page explains the differences between some of the commonly conflated content types.

## Should I create a How to, Tutorial, or 3rd-party integration guide?

| Content Type | Definition |
| - | - |
| [How to](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/how-to/) | A set of steps that you complete within a product regardless of who you are or what your application is. The tone is instructional and straightforward, tending toward concise steps with little to no additional context in each step. |
| [Tutorial](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/) | A set of steps tailored to a particular use case or application. The tone is more guiding and may include context or rationale in addition to a concise step. |
| [3rd-party integration guide](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/3rd-party-integration-guide/) | A set up steps that explains how to connect Cloudflare and a third-party product. The tone is instructional and straightforward, similar to a how to. |
