---
title: Enable Automatic Signed Exchange · Cloudflare Speed docs
description: Learn how to enable Cloudflare Automatic Signed Exchange (SXG) for
  improved content delivery.
lastUpdated: 2025-10-10T13:43:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/optimization/other/signed-exchanges/enable-signed-exchange/
  md: https://developers.cloudflare.com/speed/optimization/other/signed-exchanges/enable-signed-exchange/index.md
---

## Requirements

Before enabling Cloudflare Automatic Signed Exchange, refer to the following requirements:

* Read the [SXGs caveats](https://developers.cloudflare.com/speed/optimization/other/signed-exchanges/signed-exchanges-caveats/) to check requirements regarding request and response headers.
* SXGs are available for zones with a Pro or higher plan. SXGs are also available for zones on a Free plan with an APO subscription.
* SXGs only work with zones that have their nameservers managed by Cloudflare. Refer to [Change your nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/) to learn how to change your domain nameservers to Cloudflare. You will also have to confirm that Cloudflare is [proxying your traffic](https://developers.cloudflare.com/dns/proxy-status/).
* Zone certificates need to be managed by Cloudflare.

Note

For SXGs to be enabled, a CAA record (Certification Authority Authorization) is required to allowlist the CA (Certificate Authority) permitted to issue Certificates for signing the Signed Exchange. Cloudflare will automatically add the corresponding CAA records in DNS on behalf of users after they enable SXGs. This is to ensure that SSL certificate issuance is not blocked. If you would like to obtain SSL certificates that are issued by other CAs, make sure that you manually add the required CAA records after enabling SXGs.

* Content needs to be cached for 120 seconds or longer, as Google checks this setting to generate an SXG. To ensure that content is cached for 120 seconds or more, go to the [Cloudflare dashboard](https://dash.cloudflare.com/) > select your account and domain > **Caching** > **Configuration** > **Browser Cache TTL** and check the period of time Cloudflare instructs a browser to cache files.

## Enable SXGs

If your account satisfies all the requirements, follow the steps below to enable SXGs. Be aware that, currently, signed exchanges are only used on Chromium browsers on Android and desktop.

1. In the Cloudflare dashboard, go to the **Speed** > **Settings** page.

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/speed/optimization)

2. Go to **Other**.

3. Scroll to **Automatic Signed Exchanges (SXGs)** and enable it.

Note

To use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).
