---
title: Observatory dashboard · Cloudflare Speed docs
description: The Observatory overview dashboard provides a single view of your
  zone's performance over the past seven days. It combines synthetic monitoring,
  real user data, and Cloudflare's analysis to help you quickly identify
  performance bottlenecks and receive actionable recommendations.
lastUpdated: 2025-09-26T10:03:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/observatory/dashboard/
  md: https://developers.cloudflare.com/speed/observatory/dashboard/index.md
---

The Observatory overview dashboard provides a single view of your zone's performance over the past seven days. It combines synthetic monitoring, real user data, and Cloudflare's analysis to help you quickly identify performance bottlenecks and receive actionable recommendations.

## Suggestions

The **Suggestions** panel highlights tailored optimizations you can make to improve performance. Examples include:

* Reduce Largest Contentful Paint (LCP) with Polish.
* Reduce Time to First Byte (TTFB) with Argo Smart Routing.

These recommendations will vary based on your site's observed performance.

Selecting a suggestion expands it to show more detail:

* **Why you're seeing this**: Explains the performance issue detected.
* **What you can do**: Lists recommended actions you can take.

## Core Web Vitals

The dashboard integrates **Core Web Vitals**, showing values at the 75th percentile (p75). These metrics reflect real user experiences:

* **Largest Contentful Paint (LCP)**: How quickly the main content of a page becomes visible.
* **Interaction to Next Paint (INP)**: How responsive the site is to user interactions.
* **Cumulative Layout Shift (CLS)**: How visually stable the page layout is.

If insufficient real user data is available, metrics may show as **No data**.

## Network Performance

The **Network Performance** section shows timing data that can help pinpoint where latency occurs.

* **Time to First Byte (TTFB)**: Measures the time between the initial request and the first byte of the response.

* **Time to Last Byte (TTLB) Breakdown**: Provides a breakdown of response phases:

  * DNS resolution time
  * TCP connection time
  * Request processing time at the server
  * Response transfer time

This breakdown helps identify whether delays are caused by DNS, connection setup, server processing, or response delivery.

## HTTP Traffic

The **HTTP Traffic** section shows how traffic is handled between Cloudflare and your origin server:

* **Served by**: Percentage of requests served from Cloudflare versus from your origin.
* **4xx errors**: Client errors, broken down by Cloudflare edge versus origin.
* **5xx errors**: Server errors, broken down by Cloudflare edge versus origin.

This view helps distinguish between Cloudflare-side issues and origin-side issues.

## Synthetic Monitoring

The **Synthetic Monitoring** table shows automated test results for your site. Each row includes:

* **URL tested**
* **Last test run**
* **Repeats** (if scheduled multiple times)
* **Score** (Pass/Fail)

Synthetic monitoring allows you to proactively test site availability and performance under consistent conditions, complementing real user monitoring (RUM).

## Using the dashboard

Use the Speed Overview dashboard to:

* Review **Suggestions** for actionable optimizations.
* Track **Core Web Vitals** to ensure a good user experience.
* Analyze **Network Performance** to identify latency bottlenecks.
* Diagnose errors with **HTTP Traffic** insights.
* Confirm site reliability using **Synthetic Monitoring** results.
