---
title: Tutorials · Cloudflare Sandbox SDK docs
description: Learn how to build applications with Sandbox SDK through
  step-by-step tutorials. Each tutorial takes 20-30 minutes.
lastUpdated: 2025-10-15T15:03:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/tutorials/
  md: https://developers.cloudflare.com/sandbox/tutorials/index.md
---

Learn how to build applications with Sandbox SDK through step-by-step tutorials. Each tutorial takes 20-30 minutes.

[AI code executor](https://developers.cloudflare.com/sandbox/tutorials/ai-code-executor/)

Use Claude to generate Python code from natural language and execute it securely in sandboxes.

[Analyze data with AI](https://developers.cloudflare.com/sandbox/tutorials/analyze-data-with-ai/)

Upload CSV files, generate analysis code with Claude, and return visualizations.

[Code review bot](https://developers.cloudflare.com/sandbox/tutorials/code-review-bot/)

Clone repositories, analyze code with Claude, and post review comments to GitHub PRs.

[Automated testing pipeline](https://developers.cloudflare.com/sandbox/tutorials/automated-testing-pipeline/)

Clone repositories, install dependencies, run tests, and report results.

## What you'll learn

These tutorials cover real-world applications:

* **AI Code Execution** - Integrate Claude with secure code execution
* **Data Analysis** - Generate and run analysis code on uploaded datasets
* **Code Review Automation** - Clone repositories and analyze code changes
* **CI/CD Pipelines** - Automated testing workflows
* **File Operations** - Work with files and directories
* **Error Handling** - Validation and error management
* **Deployment** - Deploy Workers with containers

## Before you start

All tutorials assume you have:

* Completed the [Get Started guide](https://developers.cloudflare.com/sandbox/get-started/)
* Basic familiarity with [Workers](https://developers.cloudflare.com/workers/)
* [Docker](https://www.docker.com/) installed and running

## Related resources

* [How-to guides](https://developers.cloudflare.com/sandbox/guides/) - Solve specific problems
* [API reference](https://developers.cloudflare.com/sandbox/api/) - Complete SDK reference
