---
title: Use tag overrides to set WordPress rules to Block · Cloudflare Ruleset
  Engine docs
description: Follow the steps below to create a rule that executes a managed
  ruleset and defines an override for rules with a specific tag.
lastUpdated: 2025-04-01T09:53:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-examples/deploy-cmr-wordpress-block/
  md: https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-examples/deploy-cmr-wordpress-block/index.md
---

Follow the steps below to create a rule that executes a managed ruleset and defines an override for rules with a specific tag.

1. [Add a rule](https://developers.cloudflare.com/ruleset-engine/basic-operations/deploy-rulesets/) to a phase entry point ruleset that executes a managed ruleset.
2. [Configure a tag override](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/) that sets a specified action for all rules with a given tag.

The example below uses the [Update a zone entry point ruleset](https://developers.cloudflare.com/ruleset-engine/rulesets-api/update/) operation to perform the two steps in a single `PUT` request.

* Set the list of rules in the `http_request_firewall_managed` phase entry point ruleset to a single rule that executes the [Cloudflare Managed Ruleset](https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/).
* Override rules with the `wordpress` tag to set the action to `block`. All other rules use the default action provided by the ruleset issuer.

Example: Use tag overrides to set WordPress rules to Block at the zone level

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Response Compression Write`
* `Config Settings Write`
* `Dynamic URL Redirects Write`
* `Cache Settings Write`
* `Custom Errors Write`
* `Origin Write`
* `Managed headers Write`
* `Zone Transform Rules Write`
* `Mass URL Redirects Write`
* `Magic Firewall Write`
* `L4 DDoS Managed Ruleset Write`
* `HTTP DDoS Managed Ruleset Write`
* `Sanitize Write`
* `Transform Rules Write`
* `Select Configuration Write`
* `Bot Management Write`
* `Zone WAF Write`
* `Account WAF Write`
* `Account Rulesets Write`
* `Logs Write`
* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/phases/http_request_firewall_managed/entrypoint" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "execute",
            "expression": "true",
            "action_parameters": {
                "id": "<MANAGED_RULESET_ID>",
                "overrides": {
                    "categories": [
                        {
                            "category": "wordpress",
                            "action": "block"
                        }
                    ]
                }
            }
        }
    ]
  }'
```

Example: Use tag overrides to set WordPress rules to Block at the account level

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Mass URL Redirects Write`
* `Magic Firewall Write`
* `L4 DDoS Managed Ruleset Write`
* `Transform Rules Write`
* `Select Configuration Write`
* `Account WAF Write`
* `Account Rulesets Write`
* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/rulesets/phases/http_request_firewall_managed/entrypoint" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "execute",
            "expression": "cf.zone.name eq \"example.com\" and cf.zone.plan eq \"ENT\"",
            "action_parameters": {
                "id": "<MANAGED_RULESET_ID>",
                "overrides": {
                    "categories": [
                        {
                            "category": "wordpress",
                            "action": "block"
                        }
                    ]
                }
            }
        }
    ]
  }'
```
