---
title: Plans · Cloudflare Magic Firewall docs
description: If you are a Magic Transit or Magic WAN user, you are automatically
  provided with a standard list of Magic Firewall features. For additional
  features available for purchase, refer to the list of advanced features below.
lastUpdated: 2025-08-14T16:18:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/plans/
  md: https://developers.cloudflare.com/magic-firewall/plans/index.md
---

If you are a [Magic Transit](https://developers.cloudflare.com/magic-transit/) or [Magic WAN](https://developers.cloudflare.com/magic-wan/) user, you are automatically provided with a standard list of Magic Firewall features. For additional features available for purchase, refer to the list of advanced features below.

## Standard features

* Filtering rules based on protocol, port, IP addresses, packet length, and bit field match.
* Fast propagation of rule changes in less than a minute.
* Single dashboard to manage firewall and network configuration.
* Programmable API for automated deployment and management — compatible with infrastructure-as-code platforms like [Terraform](https://developers.cloudflare.com/terraform/).
* Traffic analytics per rule in the dashboard and using the [GraphQL API](https://developers.cloudflare.com/analytics/graphql-api/).
* Integration with [Magic WAN network-as-a-service](https://developers.cloudflare.com/magic-wan/).
* Included DDoS protection with [Magic Transit](https://developers.cloudflare.com/magic-transit/).

## Advanced features

All standard features are included with the purchase of the advanced features below:

* Customizable IP lists.
* Managed threat intelligence IP lists (Anonymizer, Botnet, Malware, Open Proxies, VPNs).
* Geoblocking based on user location by country.
* Block or allow packets based on Autonomous System Number (ASN).
* Packet captures on demand for network troubleshooting.
* [Protocol validation rules](https://developers.cloudflare.com/magic-firewall/about/protocol-validation-rules/) to inspect traffic validity and enforce a positive security model.
* [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/) filtering for outbound Internet traffic (network and HTTP policies). The Secure Web Gateway supports all TCP and UDP ports, as well as traffic sourced from RFC 1918 address space. Gateway will proxy BYOIP traffic to egress via the default Cloudflare IPs or your assigned [dedicated egress IPs](https://developers.cloudflare.com/cloudflare-one/policies/gateway/egress-policies/dedicated-egress-ips/).
* Intrusion Detection System (IDS).
