---
title: Cloudflare Load Balancing · Cloudflare Load Balancing docs
description: Cloudflare Load Balancing distributes traffic across your
  endpoints, which reduces endpoint strain and latency and improves the
  experience for end users.
lastUpdated: 2025-02-10T10:26:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/
  md: https://developers.cloudflare.com/load-balancing/index.md
---

Maximize application performance and availability

Paid add-on

Cloudflare Load Balancing distributes traffic across your [endpoints](https://developers.cloudflare.com/glossary/?term=endpoint), which reduces endpoint strain and latency and improves the experience for end users.

Note

Enterprise customers can preview this product as a [non-contract service](https://developers.cloudflare.com/billing/preview-services/), which provides full access, free of metered usage fees, limits, and certain other restrictions.

***

## Features

### Load balancing and failover

Distribute traffic evenly across your healthy endpoints, automatically failing over when an endpoint is unhealthy or unresponsive.

[Use Load balancing and failover](https://developers.cloudflare.com/load-balancing/load-balancers/)

### Active monitoring

Monitor your endpoints at configurable intervals and across multiple data centers to look for specific status codes, response text, and timeouts.

[Use Active monitoring](https://developers.cloudflare.com/load-balancing/monitors/)

### Intelligent routing

Choose whether to distribute requests based on endpoint latency, a visitor's geographic region, or even a visitor's GPS coordinates.

[Use Intelligent routing](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/)

### Custom rules

Customize the behavior of your load balancer based on the characteristics of individual requests.

[Use Custom rules](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-rules/)

### Analytics

Review comprehensive analytics to evaluate traffic flow, assess endpoint health status, and review changes in pools and pool health over time.

[Use Analytics](https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/)

***

## Related products

**[Standalone Health Checks](https://developers.cloudflare.com/health-checks/)**

Actively monitor whether your origin server is online by sending specific requests at regular intervals.

**[DNS](https://developers.cloudflare.com/dns/)**

Get enterprise-grade authoritative DNS service with the fastest response time, unparalleled redundancy, and advanced security with built-in DDoS mitigation and DNSSEC.

**[Waiting Room](https://developers.cloudflare.com/waiting-room/)**

Route excess users to a custom-branded waiting room, helping preserve customer experience and protect origin servers from being overwhelmed with requests.

***

## More resources

[Plans](https://www.cloudflare.com/plans/#overview)

Compare available Cloudflare plans.

[Pricing](https://dash.cloudflare.com/?to=/:account/:zone/traffic/load-balancing/)

Explore pricing options for Load Balancing in the dashboard.

[Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/load-balancing/)

Learn more about the structure of Cloudflare Load Balancers and their various configurations.

[Learning Paths](https://developers.cloudflare.com/learning-paths/)

Module-based guidance on Cloudflare product workflows.
