---
title: Connect with cloudflared · Cloudflare Learning Paths
description: Cloudflare Tunnel is an outbound-only daemon service that can run
  on nearly any host machine and proxies local traffic once validated from the
  Cloudflare network. User traffic initiated from the WARP endpoint client
  onramps to Cloudflare, passes down your Cloudflare Tunnel connections, and
  terminates automatically in your local network. Traffic reaching your internal
  applications or services will carry the local source IP address of the host
  machine running the cloudflared daemon.
lastUpdated: 2025-09-16T17:43:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/connect-private-network/cloudflared/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/connect-private-network/cloudflared/index.md
---

Cloudflare Tunnel is an outbound-only daemon service that can run on nearly any host machine and proxies local traffic once validated from the Cloudflare network. User traffic initiated from the WARP endpoint client onramps to Cloudflare, passes down your Cloudflare Tunnel connections, and terminates automatically in your local network. Traffic reaching your internal applications or services will carry the local source IP address of the host machine running the `cloudflared` daemon.

## Create a tunnel

To connect your private network:

* Dashboard

  1. Log in to [Zero Trust](https://one.dash.cloudflare.com) and go to **Networks** > **Tunnels**.

  2. Select **Create a tunnel**.

  3. Choose **Cloudflared** for the connector type and select **Next**.

  4. Enter a name for your tunnel. We suggest choosing a name that reflects the type of resources you want to connect through this tunnel (for example, `enterprise-VPC-01`).

  5. Select **Save tunnel**.

  6. Next, you will need to install `cloudflared` and run it. To do so, check that the environment under **Choose an environment** reflects the operating system on your machine, then copy the command in the box below and paste it into a terminal window. Run the command.

  7. Once the command has finished running, your connector will appear in Zero Trust.

     ![Connector appearing in the UI after cloudflared has run](https://developers.cloudflare.com/_astro/connector.DgDJjokf_1bYl1O.webp)

  8. Select **Next**.

  1) In the **CIDR** tab, enter the CIDR of your private network (for example, `10.0.0.0/8`).

  2) Select **Save tunnel**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Cloudflare Tunnel Write`

  2. Create a tunnel using the [`cloudflare_zero_trust_tunnel_cloudflare`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_tunnel_cloudflared) resource.

     ```tf
     resource "cloudflare_zero_trust_tunnel_cloudflared" "example_tunnel" {
       account_id = var.cloudflare_account_id
       name       = "Example tunnel"
       config_src = "cloudflare"
     }
     ```

  3. Route the CIDR of your private network through the tunnel using the [`cloudflare_zero_trust_tunnel_cloudflared_route`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_tunnel_cloudflared_route) resource:

     ```tf
     resource "cloudflare_zero_trust_tunnel_cloudflared_route" "example_tunnel_route" {
       account_id         = var.cloudflare_account_id
       tunnel_id          = cloudflare_zero_trust_tunnel_cloudflared.example_tunnel.id
       network            = "10.0.0.0/8"
       comment            = "Example tunnel route"
     }
     ```

  4. Get the [token](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/remote-tunnel-permissions/) used to run the tunnel:

     ```tf
     data "cloudflare_zero_trust_tunnel_cloudflared_token" "tunnel_token" {
       account_id = var.cloudflare_account_id
       tunnel_id = cloudflare_zero_trust_tunnel_cloudflared.example_tunnel.id
     }
     ```

     If your host machine is not managed in Terraform or you want to install the tunnel manually, you can output the token value to the CLI.

     Example: Output to CLI

     1. Output the tunnel token to the Terraform state file:

        ```tf
        output "tunnel_token" {
          value       = data.cloudflare_zero_trust_tunnel_cloudflared_token.tunnel_token.token
          sensitive   = true
        }
        ```

     2. Apply the configuration:

        ```sh
        terraform apply
        ```

     3. Read the tunnel token:

        ```sh
        terraform output -raw tunnel_token
        ```

        ```sh
        eyJhIj...
        ```

     Alternatively, pass `data.cloudflare_zero_trust_tunnel_cloudflared_token.tunnel_token.token` directly into your host's Terraform configuration or store the token in your secret management tool.

     Example: Store in HashiCorp Vault

     ```tf
     resource "vault_generic_secret" "tunnel_token" {
       path         = "kv/cloudflare/tunnel_token"


       data_json = jsonencode({
         "TUNNEL_TOKEN" = data.cloudflare_zero_trust_tunnel_cloudflared_token.tunnel_token.token
       })
     }
     ```

  5. Install `cloudflared` on a host machine in your private network and run the tunnel:

     * Linux

       1. [Download and install](https://pkg.cloudflare.com/index.html) `cloudflared`.

       2. Run the following command:

          ```sh
          sudo cloudflared service install <TUNNEL_TOKEN>
          ```

     * Windows

       1. [Download and install](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/downloads/#windows) `cloudflared`.

       2. Open Command Prompt as administrator.

       3. Run the following command:

          ```txt
          cloudflared.exe service install <TUNNEL_TOKEN>
          ```

     * macOS

       1. [Download and install](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/downloads/#macos) `cloudflared`.

       2. Open a terminal window and run the following command:

          ```sh
          sudo cloudflared service install <TUNNEL_TOKEN>
          ```

     * Docker

       1. Open a terminal window.

       2. Run the following command:

          ```sh
          docker run cloudflare/cloudflared:latest tunnel --no-autoupdate run --token <TUNNEL_TOKEN>
          ```

* Linux

  1. [Download and install](https://pkg.cloudflare.com/index.html) `cloudflared`.

  2. Run the following command:

     ```sh
     sudo cloudflared service install <TUNNEL_TOKEN>
     ```

* Windows

  1. [Download and install](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/downloads/#windows) `cloudflared`.

  2. Open Command Prompt as administrator.

  3. Run the following command:

     ```txt
     cloudflared.exe service install <TUNNEL_TOKEN>
     ```

* macOS

  1. [Download and install](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/downloads/#macos) `cloudflared`.

  2. Open a terminal window and run the following command:

     ```sh
     sudo cloudflared service install <TUNNEL_TOKEN>
     ```

* Docker

  1. Open a terminal window.

  2. Run the following command:

     ```sh
     docker run cloudflare/cloudflared:latest tunnel --no-autoupdate run --token <TUNNEL_TOKEN>
     ```

All internal applications and services in this IP range are now connected to Cloudflare.

Note

If the tunnel is disconnected:

* Ensure that your on-premise or cloud firewall allows egress traffic on the [required ports](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-with-firewall/#required-for-tunnel-operation).
* Ensure that the `cloudflared` host machine can connect to your internal applications and services. Verify that the host has the proper security group memberships and that no firewalls will block traffic between the host and the target services.

## Best practices

* Segregate production and staging traffic among different Cloudflare tunnels.
* Add a [`cloudflared` replica](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-availability/) to another host machine for an additional point of availability.
* Distribute access to critical services (for example, private DNS, Active Directory, and other critical systems) across different tunnels for blast-radius reduction in the event of a server-side outage.
* [Enable notifications](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/notifications/) in the Cloudflare dashboard to monitor tunnel health.
* [Monitor performance metrics](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/metrics/) to identify potential bottlenecks.
* [Update `cloudflared`](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/downloads/update-cloudflared/) regularly.
