---
title: What is Shadow AI? · Cloudflare Learning Paths
description: Shadow AI is the use of any AI tool or application by employees
  without the formal approval or oversight of the IT department. A common
  example is an employee using a generative AI application like ChatGPT to draft
  a report or analyze data, unknowingly exposing the company to significant
  risks. While employees often turn to these tools to increase productivity,
  their use can lead to major issues with data security, compliance, and even a
  company's reputation. For IT and security leaders, the key to managing these
  risks is to create a robust AI strategy that includes clear policies and
  governance.
lastUpdated: 2025-08-26T10:01:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/holistic-ai-security/concepts/shadow-ai/
  md: https://developers.cloudflare.com/learning-paths/holistic-ai-security/concepts/shadow-ai/index.md
---

Shadow AI is the use of any AI tool or application by employees without the formal approval or oversight of the IT department. A common example is an employee using a generative AI application like ChatGPT to draft a report or analyze data, unknowingly exposing the company to significant risks. While employees often turn to these tools to increase productivity, their use can lead to major issues with data security, compliance, and even a company's reputation. For IT and security leaders, the key to managing these risks is to create a robust AI strategy that includes clear policies and governance.

## Manage the risks of shadow AI

Since it may not be feasible to eliminate all instances of shadow AI, organizations can manage the risks by taking a balanced approach. First, it is essential to foster collaboration and open communication between IT and other departments to understand why employees are using these tools. Next, implement guardrails by developing a flexible governance framework with clear guidelines on which types of AI systems can be used and how sensitive information should be handled. Finally, monitor AI usage with network tools to track what is being used and educate employees on the risks of unauthorized AI.

To combat the risks associated with shadow AI, Cloudflare's API-driven CASB integrates with SaaS applications and cloud environments to scan for misconfigurations, unauthorized user activity, shadow IT, and other data security issues that can occur after a user has successfully logged in.
