---
title: Enable Notifications · Cloudflare Learning Paths
description: Magic Transit customers can configure Magic Tunnel health alerts to
  receive email, webhook, and PagerDuty notifications when the percentage of
  successful health checks for a Magic Tunnel drops below the selected
  service-level objective (SLO).
lastUpdated: 2025-07-18T10:46:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/data-center-protection/enable-notifications/
  md: https://developers.cloudflare.com/learning-paths/data-center-protection/enable-notifications/index.md
---

Magic Transit customers can configure Magic Tunnel health alerts to receive email, webhook, and PagerDuty notifications when the percentage of successful health checks for a Magic Tunnel drops below the selected [service-level objective (SLO)](https://developers.cloudflare.com/magic-transit/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/).

Magic Tunnel health alerts will monitor the health check success rate of each Magic Tunnel included in the alert that has actively transferred customer traffic (excluding health check traffic) over the past six hours. Customers can define an SLO threshold for the percentage of health checks that must be successful for each Magic Tunnel. If the number of successful health checks for the Magic Tunnel(s) included in the alert drops below the SLO threshold, then an alert will fire.

## Alert data

If a Magic Tunnel health alert is fired, customers can expect the following data in the email, webhook, and PagerDuty notification:

* Cloudflare account name
* Cloudflare account ID
* Alert type
* Tunnel name
* Tunnel ID
* Tunnel status
* Alert SLO
* Timestamp

## SLO thresholds

Currently, there are seven SLO threshold values that you can configure through the Cloudflare dashboard. For a more granular approach, use the [API](#set-up-magic-tunnel-health-alerts).

The SLO threshold for Magic Tunnel health alerts is the percentage of successful health checks for each Magic Tunnel in the alert:

| Alert Sensitivity Level | SLO threshold |
| - | - |
| Minimum | 95.0 |
| Very low | 96.0 |
| Low | 97.0 |
| Medium | 98.0 |
| High | 99.0 |
| Very high | 99.5 |
| Maximum | 99.9 |

The time it takes to be alerted depends on the sensitivity level you configure for your SLO thresholds. Higher sensitivity levels will notify you faster when a tunnel's health degrades, but they may also trigger alerts for brief or minor disruptions. Lower sensitivity levels reduce the chance of false alarms but may delay notifications for less severe issues. While the underlying detection timing remains consistent across sensitivity levels, the speed of notification depends on how significantly the tunnel's health has dropped and the sensitivity you have chosen. Cloudflare recommends that you [test SLO thresholds](#test-slos) to decide which one better serves your use case.

Refer to [How Cloudflare calculates Magic Tunnel health alerts](https://developers.cloudflare.com/magic-transit/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/) for more information on this topic.

## Set up Magic Tunnel health alerts

* Dashboard

  1. In the Cloudflare dashboard, go to the **Notifications** page.

     [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

  2. Select **Add**.

  3. From the **Product** drop-down menu, select **Magic Transit**.

  4. Select **Magic Tunnel Health Check Alert** > **Select** to add a notification. You can add alerts by tunnel or by data center (beta).

  Alert by tunnel

  1. Select **Alert by tunnel**.
  2. Enter a name and description for the notification.
  3. Add webhooks or an email address for the person who should receive the notification, and select **Next**.
  4. Select the **Alert Sensitivity Level** threshold from the dropdown menu. The threshold is predefined to *Medium (98.0)*. There are options available between *Minimum (95.0)* and *Maximum (99.9)*. Refer to [How Cloudflare calculates Magic Tunnel health alerts](https://developers.cloudflare.com/magic-transit/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/) for more information on this topic.
  5. From the **Alert interval** drop-down menu, set the minimum amount of time that must pass before a duplicate alert is sent to you. Options range from five minutes to seven days.
  6. Enable **Set as default alert for any new tunnels created in the future** if you want the alert sensitivity level you chose to be automatically applied to all new tunnels you create.
  7. Select **Next**.
  8. Choose the tunnels you want to receive alerts for. You can search by specific tunnel names, or filter them by type (GRE, IPsec and CNI). Select **Next**.
  9. Review the details of your alert. If you are happy with them, select **Create alert**.

  Alert by data center (beta)

  1. Select **Alert by data center**.
  2. Enter a name and description for the notification.
  3. Add webhooks or an email address for the person who should receive the notification, and select **Next**.
  4. Select the **Alert Sensitivity Level** threshold from the dropdown menu. The threshold is predefined to *Medium (98.0)*. There are options available between *Minimum (95.0)* and *Maximum (99.9)*. Refer to [How Cloudflare calculates Magic Tunnel health alerts](https://developers.cloudflare.com/magic-transit/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/) for more information on this topic.
  5. From the **Alert interval** drop-down menu, set the minimum amount of time that must pass before a duplicate alert is sent to you. Options range from five minutes to seven days.
  6. Choose the data centers you want to receive alerts for, and select **Next**.
  7. Choose the tunnels you want to receive alerts for. You can search by specific tunnel names, or filter them by type (GRE, IPsec and CNI). Select **Next**.
  8. Review the details of your alert. If you are happy with them, select **Create alert**.

* API

  Note

  Refer to the [documentation for Notifications](https://developers.cloudflare.com/notifications/get-started/) to learn about specific permissions you need to access the service via the API.

  Send a [`POST` request](https://developers.cloudflare.com/api/resources/alerting/subresources/policies/methods/create/) to create a Magic Transit tunnel health alert. You can set tunnel health alerts with any SLO value between `0` and `99.99`.

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Notifications Write`
  * `Account Settings Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/alerting/v3/policies" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "alert_type": "magic_tunnel_health_check_event",
      "description": "<DESCRIBE_POLICY>",
      "enabled": true,
      "filters": {
          "slo": [
              "99.9"
          ]
      },
      "mechanisms": {
          "email": [
              {
                  "id": "EMAIL_ADDRESS"
              }
          ]
      },
      "name": "<DESCRIBE_ALERT>"
    }'
  ```

  ```json
    {
      "result": [
        {
          "id": "f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
          "name": "<POLICY_NAME>",
          "description": "<POLICY_DESCRIPTION>",
          "enabled": true,
          "alert_type": "magic_tunnel_health_check_event",
          "mechanisms": {
            "email": [
              {
                "id": "<YOUR_EMAIL>"
              }
            ]
          },
          "created": "2024-09-11T14:13:29.585658Z",
          "modified": "2024-09-11T14:13:29.585658Z",
          "conditions": {
            "and": [
              {
                "or": [
                  {
                    "<=": [
                      {
                        "var": "slo"
                      },
                      "99.9"
                    ]
                  }
                ]
              }
            ]
          },
          "filters": {
            "slo": ["99.9"]
          }
        }
      ],
      "success": true,
      "errors": [],
      "messages": []
    }
  ```

## Test SLOs

To test whether a specific alert sensitivity level works for your use case:

1. [Create an alert](#set-up-magic-tunnel-health-alerts) with a specific sensitivity level for a tunnel with active traffic within the past six hours. If you are not sure of what tunnels to choose, refer to [Network Analytics](https://developers.cloudflare.com/magic-transit/analytics/network-analytics/) to learn how you can view real-time and historical data about your network.
2. Disable the tunnel you are testing, so there is 100% [health check failure](https://developers.cloudflare.com/magic-transit/reference/tunnel-health-checks/).
3. The time it takes for Cloudflare to send you an alert will depend on the sensitivity you chose for your alerts.

## Other notifications

Cloudflare also recommends that you enable the following account notifications for your Magic Transit service:

* Layer 3/4 DDoS Attack Alert
* Route Leak Detection Alert (to detect BGP Hijacks)
* (Optional) Advanced Layer 3/4 DDoS Attack Alert
* (Optional) Cloudflare status - Maintenance Notification (in case you want to be alerted regarding maintenance in specific Cloudflare data centers).

Refer to [Cloudflare Notifications](https://developers.cloudflare.com/notifications/) for more information on how to enable these notifications.
