---
title: App Launcher · Cloudflare Learning Paths
description: With the Access App Launcher, users can open all applications that
  they have access to from a single dashboard.
lastUpdated: 2025-04-10T21:16:58.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/clientless-access/customize-ux/app-launcher/
  md: https://developers.cloudflare.com/learning-paths/clientless-access/customize-ux/app-launcher/index.md
---

With the Access App Launcher, users can open all applications that they have access to from a single dashboard.

The App Launcher is available at a team domain unique to your Cloudflare Zero Trust account, for example `mycompany.cloudflareaccess.com`.

Users log in using one of the identity providers configured for the account. Once Access authenticates the user, the App Launcher displays applications they are authorized to use, in the form of application tiles. Selecting an application tile launches the application's hostname, sending the user to that tool as part of their SSO flow.

![App Launcher portal](https://developers.cloudflare.com/_astro/app-launcher.BA8TF5r4_Z1EpRVo.webp)

## Enable the App Launcher

By default, the App Launcher is disabled. To enable it, you must configure a policy that defines which users can access the App Launcher.

To enable the App Launcher:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

2. Under the **App Launcher** card, select **Manage**.

3. On the **Rules** tab, [build a rule](https://developers.cloudflare.com/cloudflare-one/policies/access/) to define who can access your App Launcher portal. These rules do not impact permissions for the applications secured behind Access.

4. On the **Authentication** tab, choose the identity providers users can authenticate with.

5. Select **Save**.

The App Launcher is now available at `<your-team-name>.cloudflareaccess.com`. You can always edit your App Launcher rules by going to **Settings** > **Authentication**.

## Add a tile to the App Launcher

Tiles have a one-to-one relationship with each application you create in Access. The tile names displayed in the Access App Launcher portal correspond to the application names listed under **Access** > **Applications**. For example, if you create one application for general access to your Jira deployment and a separate application that restricts requests to a particular Jira path, a user authorized for both will see separate tiles for each. If you add multiple hostnames to a single application, the user will only see the domain selected in the application's **App Launcher** settings.

To show an Access application in the App Launcher:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Access** > **Applications**.

2. Select an application and select **Configure**.

3. Go to **Experience settings**.

4. Select **Show application in App Launcher**. The App Launcher link will only appear for users who are allowed by your Access policies. Blocked users will not see the app in their App Launcher.

   Note

   This toggle does not impact the user's ability to reach the application. Allowed users can always reach the application via a direct link, regardless of whether the toggle is enabled. Blocked users will never have access to the application.

5. (Optional) To use a custom logo for the application tile, select **Use custom logo** and enter a link to your desired image.

   Note

   If you are having issues specifying a custom logo, check that the image is served from an HTTPS endpoint. For example, `http://www.example.com/upload/logo.png` will not work. However, `https://www.example.com/upload/logo.png` will.

6. In **Application domains**, choose a domain to use for the App Launcher link.

## Customize App Launcher appearance

Note

Only available on Pay-as-you-go and Enterprise plans.

You can display your own branding, messages, and links to users when they open the App Launcher.

To customize the App Launcher appearance:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Custom Pages**.

2. Find the **Customize App Launcher** setting and select **Customize**.

3. Give the App Launcher the look and feel of your organization by adding:

   * Your organization's name
   * A logo
   * A preferred background color for the header
   * A preferred background color for the page
   * A custom footer with links to your organization's help desk or other internal resources.

Note

We recommend lighter background colors because the font defaults to black.

1. Next, customize the landing page that users will see when they login to the App Launcher. Available properties include:

   * A custom title
   * A custom subtitle
   * An image
   * A preferred color for the **Log in** button
   * A preferred color for the **Log in** button text

   All of the properties configured in Step 3 will also apply to the landing page.

2. Once you are satisfied with your customization, select **Save**.

The App Launcher screens are now updated. To view your changes, select **Preview**.
