---
title: Sumo Logic · Cloudflare Email Security (formerly Area 1) docs
description: Sumo Logic integration guide
lastUpdated: 2025-08-19T18:37:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/reporting/siem-integration/sumo-logic-integration-guide/
  md: https://developers.cloudflare.com/email-security/reporting/siem-integration/sumo-logic-integration-guide/index.md
---

When Email Security detects a phishing email, the metadata of the detection can be sent directly into your instance of Sumo Logic. This document outlines the steps required to integrate Email Security with Sumo Logic.

![A diagram outlining what happens when Email Security detects a phishing email and sends it to Sumo Logic.](https://developers.cloudflare.com/_astro/opening-sumo-logic.D724z7XI_2oTlMz.webp)

## 1. Configure the Sumologic Collector

1. Log in to [Sumo Logic](https://service.sumologic.com/ui/) with an administrator account.

2. Go to **Manage Data** > **Collection** to open the collector configuration pane.

3. Select **Add Collector**.

   ![Add collector.](https://developers.cloudflare.com/_astro/step3-collector.DV_Q-NuH_2mzClp.webp)

4. In **Select Collector Type**, select **Hosted Collector**.

   ![Select Hosted Collector.](https://developers.cloudflare.com/_astro/step4-hosted.BwpzBT2q_1Y68g3.webp)

5. In **Add Hosted Collector**, enter the following settings:

   * **Name**: `Email Security Collector`
   * **Description**: `Email Security Security Collectors`
   * **Category**: Anti-Phishing

   ![Enter the settings above to configure your collector.](https://developers.cloudflare.com/_astro/step5-hosted-collector.Dfvo2eRJ_Z14plN9.webp)

6. Select **Save** > **OK** to confirm the addition of the new Collector.

7. In **Cloud APIs**, select **HTTP Logs and Metrics** to start the configuration of the data source.

   ![Select HTTP Logs and Metrics.](https://developers.cloudflare.com/_astro/step7-http-logs.CAeyFT9s_Z2sa756.webp)

8. Enter a descriptive **Name** and **Description**, and select **Save**.

   ![Enter a name and description.](https://developers.cloudflare.com/_astro/step8-name.DoCVtTkn_Zevgsi.webp)

9. The system will present you a dialog box with the HTTP endpoint. Save it, as this will be required to configure Email Security later.

   ![Take note of the endpoint to use it later.](https://developers.cloudflare.com/_astro/step9-endpoint.C6vCpzu8_Zm6IHl.webp)

## 2. Configure Email Security

The next step is to configure Email Security to push the Email Detection Events to the Sumologic HTTP Collector.

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/).

2. Go to **Email Configuration** > **Alert Webhooks**, and select **New Webhook**.

3. In the Add Webhooks page, enter the following settings:

   * **App type**: Select **SIEM** > **Splunk**. In **Auth code**, enter `Sumologic`.
   * **Target**: Enter the HTTP endpoint you saved in the previous section.
   * For the dispositions (`MALICIOUS`, `SUSPICIOUS`, `SPOOF`, `SPAM`, `BULK`) choose which (if any) you want to send to the webhook. Sending `SPAM` and `BULK` dispositions will generate a high number of events.

4. Select **Publish Webhook**.

Your Sumo Logic integration will now show up in the All Webhooks panel.

![Your Sumo Logic webhook will display in the All Webhooks panel.](https://developers.cloudflare.com/_astro/all-webhooks.IezPBtTD_ZdAwqn.webp)

It will take about ten minutes for the configuration to fully propagate through the infrastructure of Email Security, and for events to start to appear in your searches. Once the configuration is propagated, events will start to appear in your instance of Sumo Logic.

To view logs, hover your mouse over the Email Security Collector, and select **Open in Log Search**.

![View logs in Sumo Logic.](https://developers.cloudflare.com/_astro/open-log.CBQyENq6_10FIMO.webp)

Once events start to flow, select **New** > **Log search** to search for the detection events with your search criteria (for example, `_collector="Email Security Collector"`).

![Search for events.](https://developers.cloudflare.com/_astro/search-events.BTW9c3Ni_BDSBG.webp)
