---
title: Configuration guides · Cloudflare Data Localization Suite docs
description: Learn how to use Cloudflare products with the Data Localization Suite.
lastUpdated: 2025-01-28T15:34:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/how-to/
  md: https://developers.cloudflare.com/data-localization/how-to/index.md
---

Learn how to use Cloudflare products with the Data Localization Suite.

* [Zero Trust](https://developers.cloudflare.com/data-localization/how-to/zero-trust/)
* [Pages](https://developers.cloudflare.com/data-localization/how-to/pages/)
* [Cache](https://developers.cloudflare.com/data-localization/how-to/cache/)
* [Load Balancing](https://developers.cloudflare.com/data-localization/how-to/load-balancing/)
* [Cloudflare for SaaS](https://developers.cloudflare.com/data-localization/how-to/cloudflare-for-saas/)
* [R2 Object Storage](https://developers.cloudflare.com/data-localization/how-to/r2/)
* [Durable Objects](https://developers.cloudflare.com/data-localization/how-to/durable-objects/)
* [Workers](https://developers.cloudflare.com/data-localization/how-to/workers/)

## Verify Regional Services behavior

In order to verify that Regional Services is working, customers can confirm the behavior by executing one of the following `curl` commands on a regionalized hostname:

```bash
curl -X GET -I https://<HOSTNAME>/ 2>&1 | grep cf-ray
```

```bash
curl -s https://<HOSTNAME>/cdn-cgi/trace | grep "colo="
```

The first command will return a three-letter IATA code in the [Cf-Ray](https://developers.cloudflare.com/fundamentals/reference/http-headers/#cf-ray) header, indicating the Cloudflare data center location of processing and/or TLS termination. The second command will directly return the three-letter IATA code.

For example, when a hostname is configured to use the region European Union (EU), the three-letter IATA code will always return a data center inside of the EU.
