---
title: Migrate to Named Tunnels with Load Balancer · Cloudflare Zero Trust docs
description: Migrate from Legacy Tunnels to Named Tunnels with Cloudflare Zero Trust docs.
lastUpdated: 2025-10-09T15:47:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/tutorials/migrate-lb-tunnel/
  md: https://developers.cloudflare.com/cloudflare-one/tutorials/migrate-lb-tunnel/index.md
---

Cloudflare Tunnel is available in two deployment modes: "Legacy" Tunnel and "Named" Tunnel. [Named Tunnel](https://blog.cloudflare.com/argo-tunnels-that-live-forever/) mode improves maintainability and stability by distinguishing between routing and configuration.

Unlike Legacy mode, Named Tunnels give users the ability to manage routing in the Cloudflare dashboard and to run `cloudflared` once for [multiple services](https://blog.cloudflare.com/many-services-one-cloudflared/).

If you are using Legacy Tunnel today you can migrate to Named Tunnel deployment in less than 10 minutes.

**This tutorial covers how to:**

* Migrate a Legacy Tunnel deployment to Named Tunnel model
* Use Cloudflare Load Balancer to perform a zero downtime migration

**Time to complete:**

10 minutes

See additional documentation for working with [Kubernetes](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/deployment-guides/kubernetes/).

***

## Legacy Tunnel with Cloudflare Load Balancer

This tutorial starts by documenting the steps to create a Legacy Tunnel with Cloudflare Load Balancer so that those can be compared to the migration steps. If you would prefer to start the migration now, skip to [Create a Named Tunnel](#create-a-named-tunnel).

In both modes, the first step is to create a load balancer and endpoint pool.

1. Go to **Load Balancing** and select **Create load balancer**.

2. On the **Load Balancer Setup**, select **Public load balancer**

3. Choose the website to which you want to add this load balancer.

4. On the **Hostname** page:

   * Enter a **Hostname**, which is the DNS name at which the load balancer is available. For more details on record priority, refer to [DNS records for load balancing](https://developers.cloudflare.com/load-balancing/load-balancers/dns-records/).
   * Toggle the orange cloud icon to update the [proxy mode](https://developers.cloudflare.com/load-balancing/understand-basics/proxy-modes/), which affects how traffic is routed and which IP addresses are advertised.
   * If you want [session-based load balancing](https://developers.cloudflare.com/load-balancing/understand-basics/session-affinity/), toggle the **Session Affinity** switch.

Next, [create an endpoint pool](https://developers.cloudflare.com/load-balancing/pools/create-pool/#create-a-pool) for the load balancer. A pool is a group of endpoints or origins, whether Cloudflare Tunnel connections or traditional IP addresses, used by the load balancer.

In Legacy mode, adding a new instance of `cloudflared` into a Load Balancer pool must be done from the command line tool itself. The `cloudflared` agent will start and create 4 separate connections, enrolling each of these into a load balancer pool.

```sh
cloudflared tunnel --hostname app.widgetcorp.tech --url http://localhost:8000 --lb-pool lisbon-data-center
```

For this example, the load balancer `app.widgetcorp.tech` would have a pool `lisbon-data-center` with endpoints similar to the following:

| Endpoint Name | Endpoint Address | Weight |
| - | - | - |
| `0-51cc...d004` | `tunnel:snf...aad` | 1 |
| `1-51cc...d004` | `tunnel:10x...x1b` | 1 |
| `2-51cc...d004` | `tunnel:yeq...y15` | 1 |
| `3-51cc...d004` | `tunnel:vn6...7p6` | 1 |

However, the Legacy Tunnel mode has some downsides, including:

* You cannot manage these connections from the Cloudflare dashboard.
* When `cloudflared` restarts, it will attempt to register these connections as new connections which can lead to service disruption.

The Named Tunnel, documented below, model provides easier management and greater stability.

## Create a Named Tunnel

To migrate to the Named Tunnel model, first [download and authenticate](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) `cloudflared`. Install the agent within your environment in a location that can reach the service you plan to connect to Cloudflare.

To begin, create a Named Tunnel with the following command.

```sh
cloudflared tunnel create lisbon-app
```

This command will create a Tunnel object in your Cloudflare account that is represented by this instance of `cloudflared`. You can point DNS records or LB records to this connection when you run the Tunnel.

## Create a configuration file

Next, configure your Tunnel. The example below consists of a web service that is available at port 8000. The ingress rule will send traffic that `cloudflared` receives for the specified hostname to that port. You can also connect [multiple services](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/do-more-with-tunnels/local-management/configuration-file/#file-structure-for-public-hostnames) with a single instance of `cloudflared`.

In the configuration file, you must specify the location of the credentials file generated previously when you created the Tunnel.

![Example of configuration file that specifies the location of the credentials file](https://developers.cloudflare.com/_astro/tunnel-config.DjTOAuyg_1QWaXK.webp)

Save the configuration file.

## Run the Tunnel

You can now run the Tunnel. Running the Tunnel will connect `cloudflared` to Cloudflare's edge in a connection only available to your account. You can use the Tunnel ID value to treat that connection like the IP address of an endpoint or origin, without the risk of someone reaching it directly and bypassing Cloudflare.

Run the following command, replacing `lisbon-app` with the name of your Tunnel.

```sh
cloudflared tunnel run lisbon-app
```

## Migrate the Load Balancer configuration

You can now begin migrating your Load Balancer deployment to use the new Named Tunnel. Create a new pool in the load balancer. Add a new endpoint to the list.

In the **Endpoint Address** field, input the ID of the tunnel followed by `cfargotunnel.com`.

In this example, the endpoint address value would be `6b9b8f72-b655-46fb-b008-a45366e26b48.cfargotunnel.com`.

| Endpoint Name | Endpoint Address | Weight |
| - | - | - |
| `lisbon-data-center-one` | `6b9b8f72-b655-46fb-b008-a45366e26b48.cfargotunnel.com` | 1 |

Wait 1 minute while the new origin is recognized as healthy by Cloudflare Load Balancer. Once healthy, you can begin to disable the Legacy Argo Tunnel endpoints from the legacy Load Balancer pool.
