---
title: DEX notifications · Cloudflare Zero Trust docs
description: Administrators can receive alerts when Cloudflare detects
  connectivity issues with the WARP client or degraded application performance.
  Notifications can be delivered via email, webhook, and third-party services.
lastUpdated: 2025-02-28T10:40:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/
  md: https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/index.md
---

Administrators can receive alerts when Cloudflare detects connectivity issues with the WARP client or degraded application performance. Notifications can be delivered via email, webhook, and third-party services.

## Manage notifications

DEX notifications are configured on the [Cloudflare dashboard](https://dash.cloudflare.com/). For more information, refer to [Create a notification](https://developers.cloudflare.com/notifications/get-started/#create-a-notification).

## Available notifications

Device connectivity anomaly

**Who is it for?**

Zero Trust customers who want to be notified when Cloudflare detects a spike or drop in the number of devices connected to the WARP client.

**Other options / filters**

* **Alert configuration**: Choose when to trigger a notification. Available options are *Connectivity spike*, *Connectivity drop*, and *Connectivity spike or drop*.

* Filters:

  * **Colo**: Cloudflare data center that the device is connected to.
  * **Platform**: Operating system of the device.
  * **Version**: WARP client version (for example, `2024.3.409.0`).
  * **Mode**: [WARP mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/) deployed on the device.

**Included with**

All Cloudflare Zero Trust plans.

**What should you do if you receive one?**

Review your [fleet status](https://developers.cloudflare.com/cloudflare-one/insights/dex/fleet-status/) to investigate why the spike or drop occurred and which devices are impacted.

**Additional information**

To learn more about the alert logic, refer to [Z-score](https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/#z-score).

DEX test latency

**Who is it for?**

Zero Trust customers who wish to receive alerts when there is a spike or drop in application latency, as measured by the HTTP test [Resource Fetch time](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/http/#test-results) or Traceroute test [Round trip time](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/traceroute/#test-results). Requires setting up a [DEX test](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/).

**Other options / filters**

* **Alert configuration**: Choose when to trigger a notification. Available options are *Latency spike*, *Latency drop*, and *Latency spike or drop*.

* Filters:

  * **Colo**: Cloudflare data center that the device is connected to.
  * **Platform**: Operating system of the device.
  * **Version**: WARP client version (for example, `2024.3.409.0`).
  * **Test name**: Choose which DEX test the alert should monitor. You will receive individual notifications for each test.

**Included with**

All Cloudflare Zero Trust plans.

**What should you do if you receive one?**

View your [test results](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/view-results/) to investigate why the spike occurred.

**Additional information**

To learn more about the alert logic, refer to [Z-score](https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/#z-score).

DEX test low availability

**Who is it for?**

Zero Trust customers who wish to receive alerts when the percentage of successful HTTP or traceroute requests to an application drops below the selected service-level objective (SLO). Requires setting up a [DEX test](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/).

**Other options / filters**

* **Service Level Objective (SLO)**: Specify the availability threshold that will trigger an alert. Enter a percentage in `xx.x` format (for example, `98.0`).

* Filters:

  * **Colo**: Cloudflare data center that the device is connected to.
  * **Platform**: Operating system of the device.
  * **Version**: WARP client version (for example, `2024.3.409.0`).
  * **Test name**: Choose which DEX test the alert should monitor. You will receive individual notifications for each test.

**Included with**

All Cloudflare Zero Trust plans.

**What should you do if you receive one?**

View your [test results](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/view-results/) to investigate why the degradation occurred.

**Additional information**

To learn more about the alert logic, refer to [SLO](https://developers.cloudflare.com/cloudflare-one/insights/dex/notifications/#slo).

## ​​Alert logic

### Z-score

Cloudflare uses a z-score to detect traffic spikes or drops. A [z-score](https://en.wikipedia.org/wiki/Standard_score) is the number of standard deviations the current value is to the mean. We calculate the mean and standard deviation by comparing the current five minutes to the past four hours. This is measured every five minutes.

To trigger an alert, the z-score value must be above 3.5 or less than -3.5.

### SLO

A service-level objective (SLO) is defined as (x / y) \* 100 where x = the number of good events and y = the number of valid events for a given time period. DEX notifications look at both a short window (five minutes) and a long time window (one hour) and triggers an alert if the availability falls below the SLO threshold in either window.
