---
title: Identity · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust integrates with your organization's identity
  provider to apply Zero Trust and Secure Web Gateway policies. If you work with
  partners, contractors, or other organizations, you can integrate multiple
  identity providers simultaneously.
lastUpdated: 2025-07-07T17:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/
  md: https://developers.cloudflare.com/cloudflare-one/identity/index.md
---

Cloudflare Zero Trust integrates with your organization's identity provider to apply Zero Trust and Secure Web Gateway policies. If you work with partners, contractors, or other organizations, you can integrate multiple identity providers simultaneously.

As an alternative to configuring an identity provider, Cloudflare Zero Trust can send a [one-time PIN (OTP)](https://developers.cloudflare.com/cloudflare-one/identity/one-time-pin/) to approved email addresses. No configuration needed — simply add a user's email address to an [Access policy](https://developers.cloudflare.com/cloudflare-one/policies/access/) and to the group that allows your team to reach the application.

You can simultaneously configure an OTP and an identity provider to allow users to use their own authentication method.

Additionally, Cloudflare Zero Trust can integrate with [endpoint protection providers](https://developers.cloudflare.com/cloudflare-one/identity/devices/) to check requests for device posture. This allows you to configure security policies that rely on additional signals from endpoint security providers to allow or deny connections to your applications.

* [One-time PIN login](https://developers.cloudflare.com/cloudflare-one/identity/one-time-pin/)
* [Device posture](https://developers.cloudflare.com/cloudflare-one/identity/devices/)
* [User management](https://developers.cloudflare.com/cloudflare-one/identity/users/)
* [Service tokens](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/)
* [Authorization cookie](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/)
* [SSO integration](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/)
