---
title: OneLogin · Cloudflare Zero Trust docs
description: OneLogin provides SSO identity management. Cloudflare Access
  supports OneLogin as an OIDC identity provider.
lastUpdated: 2025-06-30T18:27:31.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/onelogin-oidc/
  md: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/onelogin-oidc/index.md
---

OneLogin provides SSO identity management. Cloudflare Access supports OneLogin as an OIDC identity provider.

## Set up OneLogin as an OIDC provider

### 1. Create an application in OneLogin

1. Log in to your OneLogin admin portal.

2. Go to **Applications** > **Applications** and select **Add App**.

3. Search for `OIDC` and select **OpenId Connect (OIDC)** by OneLogin, Inc.

4. In **Display Name**, enter any name for your application. Select **Save**.

5. Next, go to **Configuration**. In the **Redirect URI** field, enter the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

   You can find your team name in Zero Trust under **Settings** > **Custom Pages**.

6. Select **Save**.

7. Go to **Access** and choose the **Roles** that can access this application. Select **Save**.

8. Go to **SSO** and select **Show client secret**.

9. Copy the **Client ID** and **Client Secret**.

### 2. Add OneLogin to Zero Trust

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

2. Under **Login methods**, select **Add new**.

3. Select **OneLogin**.

4. Fill in the following information:

   * **Name**: Name your identity provider.
   * **App ID**: Enter your OneLogin client ID.
   * **Client secret**: Enter your OneLogin client secret.
   * **OneLogin account URL**: Enter your OneLogin domain, for example `https://<your-domain>.onelogin.com`.

5. (Optional) To enable SCIM, refer to [Synchronize users and groups](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/generic-oidc/#synchronize-users-and-groups).

6. (Optional) Under **Optional configurations**, enter [custom OIDC claims](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/generic-oidc/#custom-oidc-claims) that you wish to add to your user's identity.

7. Select **Save**.

To test that your connection is working, go to **Authentication** > **Login methods** and select **Test** next to OneLogin.

## Example API Config

```json
{
  "config": {
    "client_id": "<your client id>",
    "client_secret": "<your client secret>",
    "onelogin_account": "https://mycompany.onelogin.com"
  },
  "type": "onelogin",
  "name": "my example idp"
}
```
