---
title: GitHub · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust allows your team to connect to your
  applications using their GitHub login. You do not need to have a GitHub
  organization to use the integration.
lastUpdated: 2025-06-25T17:44:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/github/
  md: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/github/index.md
---

Cloudflare Zero Trust allows your team to connect to your applications using their GitHub login. You do not need to have a GitHub organization to use the integration.

## Set up GitHub Access

To configure GitHub access in both GitHub and Cloudflare Zero Trust:

1. Log in to [GitHub](https://github.com/).

2. Go to your account **Settings** > **Developer Settings**.

3. In **Developer Settings**, select **OAuth Apps** and select **New OAuth app**.

4. On the **Register a new OAuth application** page, enter an **Application name**. Your users will see this application name on the login page.

5. In the **Homepage URL** field, enter your team domain:

   ```txt
   https://<your-team-name>.cloudflareaccess.com
   ```

   You can find your team name in [Zero Trust](https://one.dash.cloudflare.com) by going to **Settings** > **Custom Pages**.

6. In the GitHub **Authorization callback URL** field, enter the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

7. Select **Register application**.

8. Find the **Client ID** and **Client Secret**.

9. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

10. Under **Login methods**, select **Add new**.

11. Choose **GitHub** on the next page.

12. In the **App ID** field, copy and paste the **Client ID** you found in step 8. In the **Client secret** field, copy and paste the **Client secret** you found in step 8. You will need to select **Generate a new client secret** if one is not already displayed.

13. Select **Save**.

To test that your connection is working, go to [Zero Trust](https://one.dash.cloudflare.com) > **Authentication** > **Login methods** and select **Test** next to your GitHub login method. If you have GitHub two-factor authentication enabled, you will need to first login to GitHub directly and return to Access.

## Example API Configuration

```json
{
  "config": {
    "client_id": "<your client id>",
    "client_secret": "<your client secret>"
  },
  "type": "github",
  "name": "my example idp"
}
```
