---
title: WARP client checks · Cloudflare Zero Trust docs
description: These device posture checks are performed by the Cloudflare WARP
  client. To use this feature, you must deploy the WARP client to your devices
  and enable the desired posture checks.
lastUpdated: 2024-08-16T21:25:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/index.md
---

These device posture checks are performed by the [Cloudflare WARP client](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/). To use this feature, you must [deploy the WARP client](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) to your devices and enable the desired posture checks.

## Supported WARP modes

* Gateway with WARP
* Secure Web Gateway without DNS filtering
* Device Information Only

## Supported operating systems

| Device posture check | macOS | Windows | Linux | iOS | Android/ChromeOS |
| - | - | - | - | - | - |
| [Application check](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/application-check/) | ✅ | ✅ | ✅ | ❌ | ❌ |
| [Carbon Black](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/carbon-black/) | ✅ | ✅ | ✅ | ❌ | ❌ |
| [Client certificate](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/client-certificate/) | ✅ | ✅ | ✅ | ❌ | ❌ |
| [Device serial numbers](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/corp-device/) | ✅ | ✅ | ✅ | ❌ | ❌ |
| [Device UUID](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/device-uuid/) | ❌ | ❌ | ❌ | ✅ | ✅ |
| [Disk encryption](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/disk-encryption/) | ✅ | ✅ | ✅ | ❌ | ❌ |
| [Domain joined](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/domain-joined/) | ❌ | ✅ | ❌ | ❌ | ❌ |
| [File check](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/file-check/) | ✅ | ✅ | ✅ | ❌ | ❌ |
| [Firewall](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/firewall/) | ✅ | ✅ | ❌ | ❌ | ❌ |
| [OS version](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/os-version/) | ✅ | ✅ | ✅ | ✅ | ✅ |
| [Require Gateway](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-gateway/) | ✅ | ✅ | ✅ | ✅ | ✅ |
| [Require WARP](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/require-warp/) | ✅ | ✅ | ✅ | ✅ | ✅ |
| [SentinelOne](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/sentinel-one/) | ✅ | ✅ | ✅ | ❌ | ❌ |
