---
title: Carbon Black · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust can check if Carbon Black is running on a
  device to determine if a request should be allowed to reach a protected
  resource.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/carbon-black/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/carbon-black/index.md
---

Cloudflare Zero Trust can check if [Carbon Black](https://www.carbonblack.com/) is running on a device to determine if a request should be allowed to reach a protected resource.

## Prerequisites

* Carbon Black agent is deployed on the device.

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/).

## Configure the Carbon Black check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.

2. Scroll down to **WARP client checks** and select **Add new**.

3. Select **Carbon Black**.

4. You will be prompted for the following information:

   1. **Name**: Enter a unique name for this device posture check.
   2. **Operating system**: Select your operating system. You will need to configure one posture check per operating system (macOS and Windows currently supported).
   3. **Application Path**: Enter the full path to the Carbon Black process to be checked (for example, `c:\program files\CarbonBlack\CarbonBlack.exe`).
   4. **Signing certificate thumbprint (recommended)**: Enter the thumbprint of the publishing certificate used to sign the binary. This proves the binary came from Carbon Black and is the recommended way to validate the process.
   5. **SHA-256 (optional)**: Enter a SHA-256 value. This is used to validate the SHA256 signature of the binary and ensures the integrity of the binary file on the device. Note: do not fill out this field unless you strictly control updates to Carbon Black, as this will change between versions.

Next, go to **Logs** > **Posture** and verify that the Carbon Black check is returning the expected results.
