---
title: Notifications · Cloudflare Zero Trust docs
description: Administrators can receive an alert when Cloudflare Tunnels in an
  account change their health or deployment status. Notifications can be
  delivered via email, webhook, and third-party services.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/notifications/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/notifications/index.md
---

Administrators can receive an alert when Cloudflare Tunnels in an account change their health or deployment status. Notifications can be delivered via email, webhook, and third-party services.

## Manage notifications

Tunnel notifications are configured on the [Cloudflare dashboard](https://dash.cloudflare.com/). For more information, refer to [Create a notification](https://developers.cloudflare.com/notifications/get-started/#create-a-notification).

## Available notifications

Tunnel Creation or Deletion Event

**Who is it for?**

Customers who want to receive a notification when Cloudflare Tunnels are created or deleted in their account.

**Other options / filters**

None.

**Included with**

All Cloudflare Zero Trust plans.

**What should you do if you receive one?**

No action is needed.

Tunnel Health Alert

**Who is it for?**

Customers who want to be warned about changes in health status for their Cloudflare Tunnels.

**Other options / filters**

None.

**Included with**

All Cloudflare Zero Trust plans.

**What should you do if you receive one?**

Monitor tunnel health over time and consider deploying [`cloudflared` replicas or load balancers](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-availability/).

**Additional information**

| Health status | Description |
| - | - |
| Healthy | The tunnel is active and serving traffic through four connections to the Cloudflare global network. |
| Degraded | The tunnel is active and serving traffic, but at least one individual connection has failed. Further degradation in [tunnel availability](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-availability/) could risk the tunnel going down and failing to serve traffic. |
| Down | The tunnel cannot serve traffic as it has no connections to the Cloudflare global network. |
| Inactive | This value is reserved for tunnels which have been created, but have never been run. |
