---
title: Tunnel availability and failover · Cloudflare Zero Trust docs
description: Our lightweight and open-source connector, cloudflared, was built
  to be highly available without any additional configuration requirements. When
  you run a tunnel, cloudflared establishes four outbound-only connections
  between the origin server and the Cloudflare network. These four connections
  are made to four different servers spread across at least two distinct data
  centers. This model ensures high availability and mitigates the risk of
  individual connection failures. This means in event a single connection,
  server, or data center goes offline, your resources will remain available.
lastUpdated: 2025-06-24T15:41:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-availability/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-availability/index.md
---

Our lightweight and open-source connector, [`cloudflared`](https://github.com/cloudflare/cloudflared), was built to be highly available without any additional configuration requirements. When you run a tunnel, `cloudflared` establishes four outbound-only connections between the origin server and the Cloudflare network. These four connections are made to four different servers spread across at least two distinct data centers. This model ensures high availability and mitigates the risk of individual connection failures. This means in event a single connection, server, or data center goes offline, your resources will remain available.

## `cloudflared` replicas

Cloudflare Tunnel also allows users to deploy additional instances of our connector, `cloudflared`, for availability and failover scenarios. We refer to these unique instances as replicas. Each replica establishes four new connections which serve as additional points of ingress to your origin, should you need them. Each of the replicas will point to the same tunnel. This ensures that your network remains up in the event a single host running `cloudflared` goes down.

By design, replicas do not offer any level of traffic steering (random, hash, or round-robin). Instead, when a request arrives to Cloudflare, it will be forwarded to the replica that is geographically closest. If that distance calculation is unsuccessful or the connection fails, we will retry others, but there is no guarantee about which connection is chosen.

### When to use `cloudflared` replicas

* To provide additional points of availability for a single tunnel.
* To allocate failover nodes within your network.
* To update the configuration of a tunnel without downtime.

### Deploy `cloudflared` replicas

To deploy multiple instances of `cloudflared`, you can create and configure one tunnel and run it on multiple hosts. If your tunnel runs as a service, only one `cloudflared` instance is allowed per host.

Remotely-managed tunnels

1. To create a remotely-managed tunnel, follow the [dashboard setup guide](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/get-started/create-remote-tunnel/).
2. On the **Tunnels** page, select your newly created tunnel. The **Connectors** section shows all of the `cloudflared` instances for that tunnel.
3. Select **Configure**.
4. Select the operating system of the host where you want to deploy a replica.
5. Copy the installation command and run it on the host.

The new replica will appear on the **Connectors** list for the tunnel.

Locally-managed tunnels

1. To create a locally-managed tunnel, complete Steps 1 through 5 in the [CLI setup guide](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/do-more-with-tunnels/local-management/create-local-tunnel/).

2. Run your newly created tunnel.

   ```sh
   cloudflared tunnel run <NAME>
   ```

   This will start a `cloudflared` instance and generate a unique `connector_id`.

3. In a separate window or on another host, run the same command again:

   ```sh
   cloudflared tunnel run <NAME>
   ```

   This will initialize another `cloudflared` instance and generate another `connector_id`.

4. Run `tunnel info` to show each `cloudflared` instance running your tunnel:

   ```sh
   cloudflared tunnel info <NAME>
   ```

This will output your tunnel UUID as well as two Connector IDs, one for each `cloudflared` process running your tunnel. With this command, you can also see that your tunnel is now being served by eight connections.

You can run the same tunnel across various `cloudflared` processes for up to 100 connections (25 replicas) per tunnel. Cloudflare Load Balancers and DNS records can still point to the tunnel and its UUID. Traffic will be sent to all `cloudflared` processes associated with the tunnel.

Deploy replicas in Kubernetes

For information about running `cloudflared` in a Kubernetes deployment, refer to the [Kubernetes guide](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/deployment-guides/kubernetes/).

## Cloudflare Load Balancers

[Cloudflare Load Balancing](https://developers.cloudflare.com/load-balancing/) allows users to proactively steer traffic away from unhealthy origins (or other [endpoints](https://developers.cloudflare.com/glossary/?term=endpoint)) and intelligently distribute the traffic load based on a multitude of steering algorithms. This process ensures that errors are not served to end users and empowers businesses to tightly couple overall business objectives to their traffic behavior.

In this model, more than one tunnel is required with identical configurations. The DNS record (`UUID.cfargotunnel.com`) for each Cloudflare Tunnel can be used at the origin within the load balancer. You can then define traffic steering policies to determine how traffic should be routed to each tunnel.

### When to use load balancers

* To intelligently steer traffic based on latency, geolocation, or other signals.
* To implement failover logic if a tunnel reaches an inactive state.
* To get alerted when a tunnel reaches an inactive state.
* To distribute traffic more evenly across your Cloudflare Tunnel-accessible origins or endpoints.

### Deploy a load balancer

Refer to the [Load Balancer page](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/lb/) for more information.
