---
title: Migrate 1.1.1.1 app · Cloudflare Zero Trust docs
description: Users can connect to Cloudflare Zero Trust services through an
  agent that runs on their device. Cloudflare previously bundled that
  functionality into the WARP client, an application that also provides
  privacy-focused DNS and VPN services for consumers (known as 1.1.1.1 w/ WARP).
  Supporting both enterprise and consumer functionality in the same application
  allowed us to build Zero Trust upon the same foundation used by millions of
  consumers across the globe, but has limited the pace at which changes could be
  released. As a result, we are launching a dedicated Cloudflare One Agent that
  replaces the WARP client for Zero Trust deployments.
lastUpdated: 2025-02-03T10:35:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/cloudflare-one-agent-migration/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/cloudflare-one-agent-migration/index.md
---

Users can connect to Cloudflare Zero Trust services through an agent that runs on their device. Cloudflare previously bundled that functionality into the [WARP client](https://developers.cloudflare.com/warp-client/), an application that also provides privacy-focused DNS and VPN services for consumers (known as 1.1.1.1 w/ WARP). Supporting both enterprise and consumer functionality in the same application allowed us to build Zero Trust upon the same foundation used by millions of consumers across the globe, but has limited the pace at which changes could be released. As a result, we are launching a dedicated Cloudflare One Agent that replaces the WARP client for Zero Trust deployments.

The Cloudflare One Agent supports all existing Zero Trust functionality. The underlying connection technology remains the same, and improvements made to performance and reliability based on feedback from 1.1.1.1 w/ WARP users will continue to be built into the Cloudflare One Agent.

## macOS, Windows, and Linux

No action is required for desktop clients at this time. The existing Cloudflare WARP client will continue to support both Zero Trust and 1.1.1.1 functionality.

## iOS and Android

Zero Trust users must migrate from the 1.1.1.1 app to the Cloudflare One Agent app. Cloudflare is no longer supporting customers using the 1.1.1.1 app for Zero Trust features.

Organizations can migrate their teams with minimal disruption in one of two modes: [manually](#migrate-manual-deployments) or via a [managed endpoint solution](#migrate-managed-deployments).

### Migrate manual deployments

If you downloaded and installed the 1.1.1.1 app manually, here are the recommended migration steps:

* android

  1. Update the **1.1.1.1** app to version 6.29 or above. The update ensures that 1.1.1.1 can [co-exist](#what-to-do-with-the-old-app) with the new Cloudflare One Agent app.

  2. If you have enabled [TLS decryption](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/tls-decryption/), ensure that you have a [Do Not Inspect policy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/initial-setup/http/) in place for the following applications:

     * *Google Services (Do Not Inspect)*
     * *Google Play Store (Do Not Inspect)*
     * *Google (Do Not Inspect)*
     * *Google Drive (Do Not Inspect)*
     * *Google Chat (Do Not Inspect)*
     * *Google Meet (Do Not Inspect)*

     This prevents certificate pinning issues when performing the Android migration.

  3. Follow [these instructions](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/manual-deployment/#ios-android-and-chromeos) to install and enroll the Cloudflare One Agent.

* ios

  1. Update the **1.1.1.1** app to version 6.22 or above. The update ensures that 1.1.1.1 can [co-exist](#what-to-do-with-the-old-app) with the new Cloudflare One Agent app.
  2. [Download](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/download-warp/#ios) the **Cloudflare One Agent** app.
  3. Launch the Cloudflare One Agent app. All settings from 1.1.1.1 will automatically migrate over to the Cloudflare One Agent. The user does not need to reauthenticate.

If you enrolled the Cloudflare One Agent in the same Zero Trust organization as 1.1.1.1, you will be automatically logged out of Zero Trust on 1.1.1.1. The 1.1.1.1 app will revert to consumer mode, and the **Login with Cloudflare Zero Trust** button on the old app will redirect to the new app.

If you enrolled the Cloudflare One Agent in a different Zero Trust organization, you will remain logged into your other Zero Trust organization on 1.1.1.1.

#### What to do with the old app

While both 1.1.1.1 and Cloudflare One Agent can exist on the device, iOS and Android will only allow one of these applications to connect at a time.

To access your company's resources, you must use the Cloudflare One Agent app.

You can use the 1.1.1.1 app for personal browsing. When connected to 1.1.1.1 w/ WARP, your traffic will be encrypted and privately routed via Cloudflare's network, and your employer will not be able to see any of your browsing activity. To learn more about consumer WARP services, refer to [WARP client](https://developers.cloudflare.com/warp-client/).

If you do not wish to use the old 1.1.1.1 app for personal browsing, you may [uninstall](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/remove-warp/#ios-and-android) it.

### Migrate managed deployments

If you deployed the 1.1.1.1 app with an [MDM provider](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/), perform the migration as follows:

* android

  1. Using your MDM tool, update the **1.1.1.1** app to version 6.29 or above. The update ensures that 1.1.1.1 can co-exist with the new Cloudflare One Agent app during the migration.

  2. Add the **Cloudflare One Agent** app from the Google Play store. Its application ID is `com.cloudflare.cloudflareoneagent`.

  3. Copy your [MDM deployment parameters](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/#android--chromeos) for the **1.1.1.1** app.

  4. Paste the MDM deployment parameters into the **Cloudflare One Agent** app configuration. Make sure that you do not accidentally overwrite the application ID (`com.cloudflare.cloudflareoneagent`).

  5. Using your MDM tool, install the **Cloudflare One Agent** on your devices.

  6. On Android, the user will need to [re-authenticate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/manual-deployment/#ios-android-and-chromeos) to the new application, following the same onboarding steps they went through initially.

* ios

  1. Using your MDM tool, update the **1.1.1.1** app to version 6.22 or above. The update ensures that 1.1.1.1 can co-exist with the new Cloudflare One Agent app during the migration.

  2. Add the **Cloudflare One Agent** app from the App store. Its application ID is `com.cloudflare.cloudflareoneagent`.

  3. Copy your [MDM deployment parameters](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/mdm-deployment/#ios) for the **1.1.1.1** app.

  4. Paste the MDM deployment parameters into the **Cloudflare One Agent** app configuration. Make sure that you do not accidentally overwrite the application ID (`com.cloudflare.cloudflareoneagent`).

  5. Using your MDM tool, install the **Cloudflare One Agent** on your devices.

  On iOS, the user does not need to re-authenticate — registration data from the 1.1.1.1 app is automatically migrated to the new Cloudflare One Agent app.

Once users have enrolled, the migration process is complete. The 1.1.1.1 app will revert to [consumer mode](#what-to-do-with-the-old-app) and ignore the existing MDM configuration profile. If you do not wish to keep the 1.1.1.1 app, you may uninstall it and delete its MDM configuration.

### Verify migration

To check whether a user has migrated, go to **My Team** > **Devices**. A device enrolled through the Cloudflare One Agent will appear as a new device with a new device ID. Their old 1.1.1.1 registration will remain as an inactive device.
