---
title: Local Domain Fallback · Cloudflare Zero Trust docs
description: By default, Cloudflare Zero Trust excludes common top-level
  domains, used for local resolution, from being sent to Gateway for processing.
  These top-level domains are resolved by the local DNS resolver configured for
  the device on its primary interface.
lastUpdated: 2025-10-07T17:38:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/index.md
---

By default, Cloudflare Zero Trust excludes common top-level domains, used for local resolution, from being sent to Gateway for processing. These top-level domains are resolved by the local DNS resolver configured for the device on its primary interface.

You can add additional domains to the Local Domain Fallback list and specify a DNS server to use in place of the Gateway resolver. The WARP client proxies these requests directly to the configured fallback servers.

## Limitations

Local Domain Fallback only applies to devices running the WARP client.

Because DNS requests subject to Local Domain Fallback bypass the Gateway resolver, they are not subject to Gateway DNS policies or DNS logging. If you want to route DNS queries to custom resolvers and apply Gateway filtering, use [resolver policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/resolver-policies/). If both Local Domain Fallback and resolver policies are configured for the same device, Cloudflare will apply client-side Local Domain Fallback rules first.

Local Domain Fallback or Gateway Resolver policies?

If your DNS server can be configured to connect to a Cloudflare on-ramp, Cloudflare recommends using Gateway Resolver policies rather than Local Domain Fallback. Gateway Resolver policies provide more visibility by allowing you to log and review DNS traffic.

### AWS

Avoid configuring your [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/) or [Resolver Policy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/resolver-policies/) to direct all `*.amazonaws.com` DNS resolution via AWS Route 53 Resolver.

Some AWS endpoints (such as `ssm.us-east-1.amazonaws.com`) are public AWS endpoints that are not resolvable via internal VPC resolution. This can break AWS Console features for users on WARP.

Only route specific Route 53 zones, or VPC Endpoints (such as `vpce.amazonaws.com`), through the internal VPC resolver.

## Manage local domains

### View domains

To view the domains subject to Local Domain Fallback:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.

2. Under **Device settings**, locate the [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) you would like to view or modify and select **Configure**.

3. Scroll down to **Local Domain Fallback** and select **Manage**.

On this page, you will see a list of domains excluded from Gateway. You can [add](#add-a-domain) or [remove](#delete-a-domain) domains from the list at any time.

Warning

Local Domain Fallback configuration only impacts where DNS requests get resolved, not the flow of traffic destined to those domains. If you want to prevent traffic from being sent to a specific domain or IP address, you must add those domains or IPs to your [Split Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) configuration.

To view the fallback domains applied to a device, you can:

* In [Zero Trust](https://one.dash.cloudflare.com/), go to **My Team** > **Devices** > find the target device and the **Last active device profile** > follow the [steps above](#view-domains).
* (Desktop only) Run `warp-cli settings` in the terminal of the target device and review the [fallback domains](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#fallback-domains) section of the output.
* (Desktop only) Collect [WARP diagnostic logs](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/warp-logs/) for the device and review the [fallback domain](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/troubleshooting/troubleshooting-guide/#fallback-domains) section in `warp_settings.txt`.

### Add a domain

To add a domain to the Local Domain Fallback list:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.

  2. Under **Device settings**, locate the [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) you would like to view or modify and select **Configure**.

  3. Scroll down to **Local Domain Fallback** and select **Manage**.

  1) In **Domain**, enter the apex domain (`example.com`) that you want to resolve using your private DNS server. All prefixes under the apex domain are subject to Local Domain Fallback (in other words, `example.com` is interpreted as `*.example.com`).

  2) In **DNS Servers**, enter the IP address of the DNS servers that should resolve that domain name.

  3) Enter an optional description and select **Save domain**.

* Terraform (v5)

  A Local Domain Fallback list is scoped to a specific [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/). If a device profile does not have a corresponding Local Domain Fallback resource, those devices will use the default local domains shown in Step 2.

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. (Optional) Create a list of domains that you can reuse across multiple device profiles. For example, you can declare a local value in the same module as your device profiles:

     ```tf
     locals {
       default_local_domains = [
         # Default Local Domain Fallback entries recommended by Cloudflare
         {
       suffix = "corp"
     },
     {
       suffix = "domain"
     },
     {
       suffix = "home"
     },
     {
       suffix = "home.arpa"
     },
     {
       suffix = "host"
     },
     {
       suffix = "internal"
     },
     {
       suffix = "intranet"
     },
     {
       suffix = "invalid"
     },
     {
       suffix = "lan"
     },
     {
       suffix = "local"
     },
     {
       suffix = "localdomain"
     },
     {
       suffix = "localhost"
     },
     {
       suffix = "private"
     },
     {
       suffix = "test"
     }
       ]
     }
     ```

  3. To configure Local Domain Fallback for the default device profile, use the [`cloudflare_zero_trust_device_default_profile_local_domain_fallback`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_default_profile_local_domain_fallback) resource. To configure Local Domain Fallback for a custom device profile, use[`cloudflare_zero_trust_device_custom_profile_local_domain_fallback`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_custom_profile_local_domain_fallback). For example:

     ```tf
     resource "cloudflare_zero_trust_device_custom_profile_local_domain_fallback" "example" {
       account_id = var.cloudflare_account_id
       policy_id  = cloudflare_zero_trust_device_custom_profile.example.id
       domains = concat(
         # Global entries
         local.default_local_domains,


         # Profile-specific entries
         [
           {
           suffix = "example.com"
           description = "Domain for local development"
           dns_server = ["1.1.1.1", "192.168.0.1"]
           }
         ]
       )
     }
     ```

  For `suffix`, specify the apex domain (`example.com`) that you want to resolve using your private DNS server. All prefixes under the apex domain are subject to Local Domain Fallback (in other words, `example.com` is interpreted as `*.example.com`). For `dns_server`, enter the IP address of the DNS servers that should resolve that domain name.

WARP tries all servers and always uses the fastest response, even if that response is `no records found`. We recommend specifying at least one DNS server for each domain. If a value is not specified, the WARP client will try to identify the DNS server (or servers) used on the device before it started, and use that server for each domain in the Local Domain Fallback list.

### Route traffic to fallback server

The WARP client routes DNS traffic to your [Local Domain Fallback server](#add-a-domain) according to your [Split Tunnel configuration](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/). To ensure that queries can reach your private DNS server:

* If your DNS server is only reachable inside of the WARP tunnel (for example, via `cloudflared` or Magic WAN):

  1. Go to **Networks** > **Routes** and verify that the DNS server is connected to Cloudflare. To connect a DNS server, refer to [Private networks](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/).

  2. In your [Split Tunnel configuration](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/), verify that the DNS server IP routes through the WARP tunnel.

* If your DNS server is only reachable outside of the WARP tunnel (for example, via a third-party VPN), verify that the DNS server IP is [excluded from the WARP tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/).

For more information, refer to [How the WARP client handles DNS requests](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/#how-the-warp-client-handles-dns-requests).

### Delete a domain

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.

2. Under **Device settings**, locate the [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) you would like to view or modify and select **Configure**.

3. Scroll down to **Local Domain Fallback** and select **Manage**.

1) Find the domain in the list and select **Delete**.

The domain will no longer be excluded from Gateway DNS policies, effective immediately.

## Reverse DNS lookups for internal IPs

By default, Warp sends [reverse DNS queries](https://www.cloudflare.com/learning/dns/glossary/reverse-dns/) to public DNS servers. To lookup the domain name associated with an internal IP address, [add a local domain fallback entry](#add-a-domain) for `in-addr.arpa` (IPv4) and/or `ip6.arpa` (IPv6) that points to your internal DNS server IP. `in-addr.arpa` and `ip6.arpa` are top-level domains [reserved](https://www.iana.org/domains/arpa) for reverse DNS queries. By adding a local domain fallback entry for these domains, all reverse DNS queries (such as `dig -x 1.1.1.1`) will now resolve through your local DNS server.

## Related resources

* [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) - Control which traffic goes through WARP by including or excluding specific IPs or domains.
* [WARP with firewall](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/firewall/) - Learn which IPs, domains, and ports to allow so users can deploy and connect WARP successfully behind a firewall.
