---
title: Revalidation and request collapsing · Cloudflare Cache (CDN) docs
description: Revalidation is a caching mechanism that checks the freshness of
  cached data before serving it to users. If a cached object is no longer fresh
  and Cloudflare receives a request for it, the system makes a request to the
  origin to revalidate the object in the Cloudflare cache. By using headers like
  If-Modified-Since and ETag, Cloudflare validates content without fully
  re-fetching it. When these headers are missing, Smart Edge Revalidation
  generates a Last-Modified header, ensuring efficient updates and delivery of
  fresh content while reducing origin traffic.
lastUpdated: 2025-07-28T14:45:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/concepts/revalidation/
  md: https://developers.cloudflare.com/cache/concepts/revalidation/index.md
---

Revalidation is a caching mechanism that checks the [freshness](https://developers.cloudflare.com/cache/concepts/retention-vs-freshness/#freshness-ttl) of cached data before serving it to users. If a cached object is no longer fresh and Cloudflare receives a request for it, the system makes a request to the origin to revalidate the object in the Cloudflare cache. By using headers like `If-Modified-Since` and `ETag`, Cloudflare validates content without fully re-fetching it. When these headers are missing, [Smart Edge Revalidation](https://blog.cloudflare.com/introducing-smart-edge-revalidation/) generates a `Last-Modified` header, ensuring efficient updates and delivery of fresh content while reducing origin traffic.

## Revalidation towards origin

For stale (expired TTL) content, Cloudflare will send a revalidation request to the origin. If the stale content is still valid Cloudflare will set a new TTL. If the content is expired, then the origin will provide new fresh content to replace the old.

Consider the following example scenarios.

### Example 1

One-thousand (1,000) requests arrive simultaneously at Cloudflare's network, and the requested resource was in Cloudflare but cannot be served because its TTL configuration indicates it is no longer fresh. This means that the resource needs to be served from the origin server. In this case, one request will go to the origin to be revalidated, while the other 999 requests will be served from cache with the status of [UPDATING](https://developers.cloudflare.com/cache/concepts/cache-responses/#updating). This means that the resource, although expired, is served stale from Cloudflare's cache, while the origin server is updating it. This behavior is defined by the [`stale-while-revalidate`](https://developers.cloudflare.com/cache/concepts/cache-control/#revalidation) directive in `cache-control`. If you do not wish to serve stale content, set the directive to zero seconds, `stale-while-revalidate=0`.

### Example 2

One-thousand (1,000) requests arrive simultaneously at a single Cloudflare data center, and the requested asset is not in Cloudflare's cache (a cache miss). These requests will use a cache lock to communicate with your origin. This means that only the first request will go to origin to fetch the asset. The remaining 999 requests wait for the first request to fetch the data, after which the response is [streamed](https://blog.cloudflare.com/introducing-concurrent-streaming-acceleration/) to all the waiting requests. The cache lock ensures that Cloudflare only sends the origin one request at a time for a given asset from a location in Cloudflare's network, preventing the origin from getting too much traffic.

## Smart revalidation towards users

When both [`Last-Modified`](https://datatracker.ietf.org/doc/html/rfc7232?cf_history_state=%7B%22guid%22%3A%22C255D9FF78CD46CDA4F76812EA68C350%22%2C%22historyId%22%3A15%2C%22targetId%22%3A%226C8153BAEF7BC0C5A331E28F8BCF1ABA%22%7D#section-2.2) and [`Etag`](https://datatracker.ietf.org/doc/html/rfc7232?cf_history_state=%7B%22guid%22%3A%22C255D9FF78CD46CDA4F76812EA68C350%22%2C%22historyId%22%3A13%2C%22targetId%22%3A%226C8153BAEF7BC0C5A331E28F8BCF1ABA%22%7D#section-2.3) headers are absent from the origin server response, Smart Edge Revalidation will use the time the object was cached on Cloudflare's global network as the `Last-Modified` header value. When a browser sends a revalidation request to Cloudflare using `If-Modified-Since` or `If-None-Match`, our global network can answer those revalidation questions using the `Last-Modified` header generated from Smart Edge Revalidation. In this way, our global network can ensure efficient revalidation even if the headers are not sent from the origin.
